<?php
namespace WBSYCF7_deactivate;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class WBSYCF7_Deactivate
{
    public function __construct( $task )
    {
        if ($task != '' && method_exists($this, $task) && $task != '__construct') {
            $this->$task();
        } else {
            $this->enqueue_scripts();
            $this->template();
        }
    }

    private function wbsycf7_send_reason() {

        if ( ! isset($_POST['nonce']) ||
             ! wp_verify_nonce( sanitize_text_field(wp_unslash($_POST['nonce'])), 'wbsycf7_ajax_nonce' ) ) {
            wp_send_json_error(['message' => 'Security issue.']);
        }

        if( isset($_POST['skip']) && $_POST['skip'] == 0 ) {
            $email = !empty($_POST['email']) ? sanitize_email(wp_unslash($_POST['email'])) : '';
            $reason_value = isset($_POST['reason_value']) ? sanitize_text_field(wp_unslash($_POST['reason_value'])) : '';
            $message = isset($_POST['message']) ? sanitize_text_field(wp_unslash($_POST['message'])) : '';
            $reason = isset($_POST['reason']) ? sanitize_text_field(wp_unslash($_POST['reason'])) : '';

        } else { /* Skip case */
            $email = '';
            $reason = 'Skipped';
            $message = '';
            $reason_value = '';
        }

        $data = [
            'reason_value' => $reason_value,
            'message'      => $message,
            'reason'       => $reason,
            'email'        => $email,
            'plugin_name'  => 'Builder for Contact Form 7',
        ];

        // Set up the request headers
        $headers = [
            'Content-Type'  => 'application/json',
            'Authorization' => 'Bearer 833f3ab4b2ec0f49575b7e4ac82cdbfc45e217b3e18846d59c707bfafff06526',
        ];


        wp_remote_post('https://websync.tech/wp-json/tkf/v1/deactivate/', [
            'method'    => 'POST',
            'headers'   => $headers,
            'body'      => json_encode($data),
            'data_format' => 'body',
        ]);

        wp_send_json_success();
    }

    private function enqueue_scripts() {
        wp_enqueue_script('wbsycf7-deactivate');
        wp_enqueue_style('wbsycf7-deactivate');
    }

    private function template() {
        ?>
        <script type="text/template" id="wbsycf7-deactivate-template">
            <div class="wbsycf7-deactivat-layout"></div>
            <div class="wbsycf7-deactivat-container">
                <span class="wbsycf7-close dashicons dashicons-dismiss"></span>
                <div class="wbsycf7-header-row">
                    <?php esc_html_e('Please let us know why you are deactivating. Your answer will help us to provide you support or sometimes offer discounts. (Optional):', 'ws-tiktok-feed'); ?>
                </div>
                <div class="wbsycf7-reason-row">
                    <input type="radio" value="no_need" name="wbsycf7_reason" class="wbsycf7-reason">
                    <label><?php esc_html_e('I no longer need the plugin', 'ws-tiktok-feed'); ?></label>
                </div>
                <div class="wbsycf7-reason-row">
                    <input type="radio" value="free_limited" name="wbsycf7_reason" class="wbsycf7-reason">
                    <label><?php esc_html_e('Free version is limited', 'ws-tiktok-feed'); ?></label>
                </div>
                <div class="wbsycf7-reason-row">
                    <input type="radio" value="better_alternative" name="wbsycf7_reason" class="wbsycf7-reason">
                    <label><?php esc_html_e('I found a better alternative', 'ws-tiktok-feed'); ?></label>
                </div>
                <div class="wbsycf7-reason-row">
                    <input type="radio" value="conflict" name="wbsycf7_reason" class="wbsycf7-reason">
                    <label><?php esc_html_e('Technical problems / hard to use', 'ws-tiktok-feed'); ?></label>
                </div>
                <div class="wbsycf7-reason-row">
                    <input type="radio" value="upgrade" name="wbsycf7_reason" class="wbsycf7-reason">
                    <label><?php esc_html_e('Upgrading to paid version', 'ws-tiktok-feed'); ?></label>
                </div>
                <div class="wbsycf7-reason-row">
                    <input type="radio" value="other" name="wbsycf7_reason" class="wbsycf7-reason">
                    <label><?php esc_html_e('Other', 'ws-tiktok-feed'); ?></label>
                </div>

                <div class="wbsycf7-additional-row" style="display:none"></div>
                <hr>
                <div class="wbsycf7-reason-row wbsycf7-terms-agree-row">

                    <label class="wbsycf7-terms-agree-msg">
                        Please note that <b>we do not collect any personal or website data.</b> We only collect the reason you provide in order to improve our product, and we hope that you will consider using our improved version in the future.
                    </label>
                </div>

                <div class="wbsycf7-buttons-row">
                    <a href="#" class="wbsycf7-skip-button button button-secondary"><?php esc_html_e('Skip and Deactivate', 'ws-tiktok-feed'); ?></a>
                    <span class="wbsycf7-submit-button button button-primary" style="display: none"><?php esc_html_e('Submit and Deactivate', 'ws-tiktok-feed'); ?></span>
                </div>
            </div>
        </script>

        <script type="text/template" id="wbsycf7-deactivate-support-template">
            <p class="wbsycf7-issue-title"><?php esc_html_e('Please describe your issue.', 'ws-tiktok-feed'); ?></p>
            <textarea class="wbsycf7-issue-message"></textarea>
            <div class="wbsycf7-issue-email-row">
                <span><?php esc_html_e('Our support will contact', 'ws-tiktok-feed'); ?></span>
                <input type="email" value="<?php echo esc_attr(get_option('admin_email')); ?>" class="wbsycf7-admin-email">
                <span><?php esc_html_e('shortly.', 'ws-tiktok-feed'); ?></span>
            </div>
        </script>

        <script type="text/template" id="wbsycf7-deactivate-pro-offer-template">
            <p class="wbsycf7-issue-title"><?php esc_html_e('We believe our premium version will fit your needs.', 'ws-tiktok-feed'); ?></p>
            <a href="https://websync.tech/?from=plugin">
                <?php esc_html_e('Try with 30 day money back guarantee.', 'ws-tiktok-feed'); ?>
            </a>
        </script>

        <script type="text/template" id="wbsycf7-deactivate-other-template">
            <p class="wbsycf7-issue-title"><?php esc_html_e('Please describe the reason.', 'ws-tiktok-feed'); ?></p>
            <textarea class="wbsycf7-issue-message"></textarea>
        </script>

        <?php
    }
}