let wbsycf7_deactivate_link = '';
jQuery(document).ready(function () {
    let idName = 'deactivate-websync-builder-cf7';
    if( deactivate_options.pro == "1" ) {
        idName = 'deactivate-websync-builder-cf7-pro';
    }
    // Listen for plugin deactivation link click
    jQuery(document).on('click', '#'+idName, function (e) {
        e.preventDefault();
        wbsycf7_deactivate_link = jQuery(this).attr("href");
        let template = jQuery(document).find("#wbsycf7-deactivate-template").html();
        jQuery("body").append(template);
    });

    jQuery(document).on('click', '.wbsycf7-close, .wbsycf7-deactivat-layout', function (e) {
        jQuery(document).find(".wbsycf7-deactivat-layout").remove();
        jQuery(document).find(".wbsycf7-deactivat-container").remove();
    });

    jQuery(document).on('change', '.wbsycf7-reason',function() {
        let template = '';
        jQuery(document).find(".wbsycf7-terms-agree-row").show();
        jQuery(document).find(".wbsycf7-submit-button").show();
        switch (this.value) {
            case 'free_limited':
                template = jQuery(document).find("#wbsycf7-deactivate-pro-offer-template").html();
                jQuery(".wbsycf7-additional-row").empty().append(template).show();
                break;
            case 'better_alternative':
                template = jQuery(document).find("#wbsycf7-deactivate-pro-offer-template").html();
                jQuery(".wbsycf7-additional-row").empty().append(template).show();
                break;
            case 'conflict':
                template = jQuery(document).find("#wbsycf7-deactivate-support-template").html();
                jQuery(".wbsycf7-additional-row").empty().append(template).show();
                break;
            case 'other':
                template = jQuery(document).find("#wbsycf7-deactivate-other-template").html();
                jQuery(".wbsycf7-additional-row").empty().append(template).show();
                break;
            default:
                jQuery(".wbsycf7-additional-row").empty().hide();
        }
    });


    jQuery(document).on('click', '.wbsycf7-skip-button', function (e) {
        if( jQuery(this).hasClass('wbsycf7-submit-loading') ) {
            return false;
        }

        let button_text = jQuery(this).text();
        jQuery(this).addClass("wbsycf7-submit-loading").empty();

        let data = {
            action: 'wbsycf7_send_deactivation_reason',
            task: 'wbsycf7_send_reason',
            nonce: deactivate_options.nonce,
            skip: 1,
        }

        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: data,
            success: function (response) {
                jQuery(document).find('.wbsycf7-skip-button').removeClass("wbsycf7-submit-loading").text(button_text);
            },
            complete: function (response) {
                window.location.href = wbsycf7_deactivate_link;
            },
            error: function () {
                jQuery(document).find('.wbsycf7-submit-button').removeClass("wbsycf7-submit-loading").text(button_text);
            },
        });
    });

    jQuery(document).on('click', '.wbsycf7-submit-button', function (e) {
        if( jQuery(this).hasClass('wbsycf7-submit-disabled') || jQuery(this).hasClass('wbsycf7-submit-loading') ) {
            return false;
        }

        let button_text = jQuery(this).text();
        jQuery(this).addClass("wbsycf7-submit-loading").empty();

        let checked = jQuery(".wbsycf7-reason-row input[type='radio'][name=wbsycf7_reason]:checked");
        let reason_value = checked.val();
        let reason = checked.parent().find('label').text();
        let message = '';
        let email = '';

        switch (reason_value) {
            case 'conflict':
                message = jQuery(document).find(".wbsycf7-issue-message").val();
                email = jQuery(document).find(".wbsycf7-admin-email").val();
                break;
            case 'other':
                message = jQuery(document).find(".wbsycf7-issue-message").val();
                break;
            default:
                jQuery(".wbsycf7-additional-row").empty().hide();
        }

        data = {
            action: 'wbsycf7_send_deactivation_reason',
            task: 'wbsycf7_send_reason',
            reason_value: reason_value,
            reason: reason,
            message: message,
            email: email,
            nonce: deactivate_options.nonce,
            skip: 0,
        }

        setTimeout(function() {
            window.location.href = wbsycf7_deactivate_link;
        },500);

        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: data,
            success: function (response) {
                jQuery(document).find('.wbsycf7-submit-button').removeClass("wbsycf7-submit-loading").text(button_text);
            },
            complete: function (response) {
                window.location.href = wbsycf7_deactivate_link;
            },
            error: function () {
                jQuery(document).find('.wbsycf7-submit-button').removeClass("wbsycf7-submit-loading").text(button_text);
            },
        });

    });
});