<?php
$post_id = isset($_GET['post']) ? intval($_GET['post']) : 0;
$form_fields = (array) get_post_meta($post_id, '_wblscf7_form_fields', true);
?>
<script type="text/template" id="wbsycf7-conditionDefault-template">
    <div class="wbsycf7-conditionGroup-row">
        <div class="wbsycf7-conditionGroup-title-row">
            <select class="wbsycf7-condition-show-hide" name=wbsycf7_condition_show_hide">
                <option value="show">Show</option>
                <option value="hide">Hide</option>
            </select>
            <select class="wbsycf7-form-fields" name="wbsycf7_form_fields">
            <?php

            foreach ( $form_fields as $form_field ) {
                $field_name = isset($form_field['name']) ? esc_html($form_field['name']) : '';
                $field_label = !empty($form_field['label']) ? esc_html($form_field['label']) : $field_name;
                if( $field_name === '' ) continue;
                ?>
                <option value="<?php echo esc_html($field_name); ?>"><?php echo esc_html($field_label); ?></option>
            <?php } ?>
            </select>
            <span>if</span>
            <select class="wbsycf7-condition-and-or" name="wbsycf7_condition_and_or">
                <option value="all">All</option>
                <option value="any">Any</option>
            </select>
            <span>of the following match:</span>
            <div class="wbsycf7-condition-actions">
                <span class="dashicons dashicons-plus wbsycf7-condition-item-add" title="Add Condition"></span>
                <span class="dashicons dashicons-trash wbsycf7-condition-group-delete" title="Delete"></span>
            </div>
        </div>
        <div class="wbsycf7-conditionGroup-items"></div>
    </div>
</script>

<script type="text/template" id="wbsycf7-conditionItem-template">
    <div class="wbsycf7-conditionGroup-item-row">
        <select class="wbsycf7-form-items-fields" name="wbsycf7_form_items_fields">
        <?php
            foreach ( $form_fields as $form_field ) {
                $field_name = isset($form_field['name']) ? esc_html($form_field['name']) : '';
                $field_label = !empty($form_field['label']) ? esc_html($form_field['label']) : $field_name;
                if( $field_name === '' ) continue;
                ?>
                <option value="<?php echo esc_html($field_name); ?>"><?php echo esc_html($field_label); ?></option>
        <?php } ?>
        </select>
        <select class="wbsycf7-condition-equal" name="wbsycf7_condition_equal">
            <option value="is">is</option>
            <option value="is_not">is not</option>
            <option value="empty">empty</option>
            <option value="not_empty">not empty</option>
        </select>
        <input type="text" value="" class="wbsycf7-condition-value" name="wbsycf7_condition_value">
        <div class="wbsycf7-condition-actions">
            <span class="dashicons dashicons-trash wbsycf7-condition-item-delete" title="Delete"></span>
        </div>
    </div>
</script>

<!--PRO template-->
<script type="text/template" id="wbsycf7-new-page-template">
    <div class="wbsycf7-page-and-images wbsycf7-form-builder">
        <div class="wbsycf7-section">
            <div class="wbsycf7-column wbsycf7-hidden ui-sortable"></div>
            <div class="wbsycf7-column wbsycf7_column-active ui-sortable"></div>
            <div class="wbsycf7-column wbsycf7-hidden ui-sortable"></div>
        </div>
    </div>
</script>

<script type="text/template" id="wbsycf7-pageTitle-template">
    <div class="wbsycf7-row-pageTitle wbsycf7-row-page">
        <span class="wbsycf7-page-title">Page Title</span>
        <div class="wbsycf7-actions">
            <span class="dashicons dashicons-edit wbsycf7-edit-page-title" title="Edit Page Title"></span>
            <span class="dashicons dashicons-trash" title="Delete Page"></span>
        </div>
    </div>
</script>

<script type="text/template" id="wbsycf7-pageFooter-template">
    <div class="wbsycf7-row-pageFooter wbsycf7-row-page">
        <span class="wbsycf7-prevPage-button wbsycf7-page-button">Previous</span>
        <span class="wbsycf7-nextPage-button wbsycf7-page-button">Next</span>
    </div>
</script>
<!--End of PRO template-->
