<?php

namespace WBSY\CF7\Admin;

class PreviewPage
{
    public function register()
    {
        add_action('admin_init', [$this, 'ensure_preview_page']);
        add_action('init', [$this, 'register_preview_cpt']);

        add_filter('the_content', [$this, 'set_preview_shortcode']);
    }

    public function set_preview_shortcode($content) {

        if (get_post_type() === 'wblscf7_preview' && isset($_GET['form_id'])) {

            $form_id = absint($_GET['form_id']);
            $form_post = get_post($form_id);
            if ($form_post && $form_post->post_type === 'wpcf7_contact_form') {
                return do_shortcode('[contact-form-7 id="' . $form_id . '"]');
            }

            return '<p>Form not found.</p>';
        }

        return $content;
    }

    public function register_preview_cpt() {
        register_post_type('wblscf7_preview', [
            'public' => true,
            'rewrite' => ['slug' => 'wblscf7-preview'],
            'has_archive' => false,
            'supports' => ['title', 'editor'],
            'publicly_queryable' => true,
            'show_in_menu' => false,
            'label' => 'CF7 Preview Page'
        ]);
    }

    public function ensure_preview_page() {
        $existing = get_page_by_path( 'preview', OBJECT, 'wblscf7_preview' );
        
        if (!$existing) {
            wp_insert_post([
                'post_title'     => 'CF7 Builder Preview',
                'post_name'      => 'preview',
                'post_status'    => 'publish',
                'post_type'      => 'wblscf7_preview',
                'post_content'   => '',
            ]);
        }
    }

}
