jQuery(document).ready(function(jQuery) {
    // Pro start
    wbsycf7ActionAfterSubmit();
    wbsycf7ChangePage();
    // Pro end

    jQuery(document).on('submit', '.wpcf7 form', function(){
        const $form = jQuery(this);

        // Browser-side: remove required markers from hidden rows
        $form.find('.wbsycf7-conditional-hidden').find('input, select, textarea').each(function(){
            jQuery(this)
                .removeAttr('required')
                .removeAttr('aria-required')
                .removeClass('wpcf7-validates-as-required');
        });

        // Server-side: send hidden list
        const hiddenNames = wbsyCollectHiddenNames($form);
        wbsyEnsureHiddenList($form).val(JSON.stringify(hiddenNames));
    });
});

// Compute hidden field names from rows that are currently hidden
function wbsyCollectHiddenNames($form){
    const names = [];
    $form.find('.wbsycf7-conditional-hidden .wpcf7-form-control-wrap').each(function(){
        const n = jQuery(this).attr('data-name');
        if (n) names.push(n);
    });
    return names;
}

// Ensure hidden input exists
function wbsyEnsureHiddenList($form){
    let $inp = $form.find('input[name="wbsycf7_hidden_names"]');
    if (!$inp.length) {
        $inp = jQuery('<input type="hidden" name="wbsycf7_hidden_names">').appendTo($form);
    }
    return $inp;
}

/*Pro start*/
// A field is "conditionally hidden" if its row has the class or isn't visible
function wbsycf7_isHiddenByCondition($input) {
    const $row = $input.closest('.wbsycf7-form-row');
    if (!$row.length) return false;
    if ($row.hasClass('wbsycf7-conditional-hidden')) return true;
    if (!$row.is(':visible')) return true;                // safety: CSS-hidden
    if ($row.css('display') === 'none') return true;      // extra safety
    if ($row.css('visibility') === 'hidden') return true; // extra safety
    return false;
}

function wbsycf7ActionAfterSubmit() {
    jQuery(document).on('wpcf7submit', function(event) {
        const status = event.detail.status;

        // Consider these as NOT successful submissions:
        if (['validation_failed', 'spam', 'aborted'].includes(status)) return;

        const $form = jQuery(event.target);
        const raw = $form.attr('data-wblscf7-settings');

        if (!raw) return;

        let settings;
        try {
            settings = JSON.parse(raw);
        } catch (e) {
            return;
        }

        // Delay message overwrite slightly to avoid being overwritten
        if (settings.success_action === 'custom_text' && settings.custom_success_message) {
            setTimeout(function() {
                const $message = $form.find('.wpcf7-response-output');
                if ($message.length) {
                    $message.html(settings.custom_success_message);
                }
            }, 100); // 100ms is usually enough
        }

        // Redirect if needed
        if (settings.success_action === 'redirect' && settings.redirect_page_id) {
            const redirectUrl = $form.find('input[name="redirect_url"]').val();
            if (redirectUrl) {
                window.location.href = redirectUrl;
            }
        }
    });
}

function wbsycf7ChangePage() {
    jQuery(document).on("click", ".wbsycf7-nextPage-button", function(e) {
        e.preventDefault();


        const $page = jQuery(this).closest('.wbsycf7-page-and-images');
        let valid = true;

        valid = wbsycf7_validateStep($page);

        if (valid) {
            jQuery(document).find(".wbsycf7-page-and-images").hide();
            jQuery(this).closest(".wbsycf7-page-and-images").next(".wbsycf7-page-and-images").show();
        }


    });

    jQuery(document).on("click", ".wbsycf7-prevPage-button", function(event) {
        jQuery(document).find(".wbsycf7-page-and-images").hide();
        jQuery(this).closest(".wbsycf7-page-and-images").prev(".wbsycf7-page-and-images").show();
    });



}

// Clear any error state on a field (used when it becomes hidden)
function wbsycf7_clearInvalid($input) {
    $input.removeClass('wpcf7-not-valid').attr('aria-invalid', 'false');
    const $wrap = $input.closest('.wpcf7-form-control-wrap');
    $wrap.siblings('.wpcf7-not-valid-tip').hide().attr('aria-hidden', 'true');
}

function wbsycf7_validateStep($container) {
    // All "required" selectors CF7 commonly uses
    const $required = $container.find(
        '.wpcf7-validates-as-required, [aria-required="true"], [required]'
    );

    let ok = true;

    $required.each(function () {
        const $f = jQuery(this);

        // Skip if hidden by condition
        if (wbsycf7_isHiddenByCondition($f)) {
            wbsycf7_clearInvalid($f); // also clear any leftover error UI
            return; // continue
        }

        // Your required check (trim if text-like; adapt for radios/checkboxes)
        let valid = true;
        if ($f.is(':checkbox') || $f.is(':radio')) {
            const name = $f.attr('name');
            valid = !!$container.find(`[name="${CSS.escape(name)}"]`).filter(':checked').length;
        } else if ($f.is('select')) {
            valid = !!($f.val() && String($f.val()).trim() !== '');
        } else {
            valid = !!( ($f.val() || '').trim() );
        }

        if (!valid) {
            ok = false;
            // Mark invalid (CF7-like)
            $f.addClass('wpcf7-not-valid').attr('aria-invalid', 'true');
            const $wrap = $f.closest('.wpcf7-form-control-wrap');
            let $tip = $wrap.siblings('.wpcf7-not-valid-tip');
            if (!$tip.length) {
                $tip = jQuery('<span class="wpcf7-not-valid-tip" aria-hidden="false">This field is required.</span>');
                $wrap.after($tip);
            } else {
                $tip.text('This field is required.').show().attr('aria-hidden', 'false');
            }
        } else {
            wbsycf7_clearInvalid($f);
        }
    });

    return ok;
}
/*Pro end*/