jQuery(document).ready(function($) {

    jQuery(document).on('click', '.wbsycf7-buy-pro-layer', function (e) {
        jQuery(".wbsycf7-buy-pro-layer, .wbsycf7-buy-pro-container").remove();
    });

    jQuery("#wpcf7-form").prop('readonly', true);
    jQuery('#wpcf7-admin-form-element').on('submit', function () {
        let builderHtml = jQuery('.wbsycf7-builder-preview').prop('outerHTML');
        jQuery('#wbsycf7_builder_html').val(builderHtml);
    });

    jQuery(document).on('click', '[data-taggen="open-dialog"]', function () {
        setTimeout(() => {
            const $panel = jQuery('.tag-generator-panel:visible');

            // Prevent duplicate buttons
            $panel.find('.wbsycf7-insert-button, .wbsycf7-update-button').remove();
            const insertBtn = jQuery('<button class="button button-primary wbsycf7-insert-button">Add Field</button>');
            $panel.find("button[data-taggen='insert-tag']").after(insertBtn);
        }, 100); // Wait for popup to render
    });


    jQuery(document).on('click', '.wbsycf7-actions .dashicons-trash', function (e) {
        e.preventDefault();
        if( jQuery(this).closest(".wbsycf7-row-pageTitle").length ) {
            if (confirm('Are you sure you want to delete this page and all fields in the page?')) {
                jQuery(this).closest(".wbsycf7-page-and-images").remove();
                wbsycf7SetPageTitle();
            }
        } else {
            if (confirm('Are you sure you want to delete this field?')) {
                jQuery(this).closest(".wbsycf7-form-row").remove();
            }
        }
    });


    let template = jQuery('#wblscf7-preview-button-template');
    if (template.length) {
        let buttonHtml = template.html();

        // Where to insert the button
        // You can change this selector based on your custom tab or panel
        let target = jQuery('#titlediv .inside'); // Adjust as needed

        if (target.length) {
            target.append(buttonHtml);
        } 
    }
    // Initialize select2
    jQuery('#wblscf7-redirect-page-id').select2({
        placeholder: 'Select a page...',
        allowClear: true,
        width: 'resolve'
    });

    wbsycf7RunDragDrop();

    // Pro start
    jQuery('#wblscf7-success-action').on('change', toggleFields);
    toggleFields();

    jQuery(document).on('click', '.wbsycf7-add-new-page', function (e) {
        e.preventDefault();
        wbsycf7AddNewPage(jQuery(e));
        wbsycf7SetPageTitle();
    });

    wbsycf7EditPageTitle();

    jQuery(document).on('change', '.wblscf7-field-option', function () {
        var $ta = jQuery('#wpcf7-additional-settings'); // your textarea
        var text = $ta.val();
        var option = jQuery(this).data('option'); // e.g. "demo_mode: on"

        if (this.checked) {
            // Add if not already there
            if (text.indexOf(option) === -1) {
                $ta.val((text + "\n" + option).trim());
            }
        } else {
            // Remove line containing that option
            var lines = text.split(/\r?\n/).filter(function(line){
                return line.trim() !== option;
            });
            $ta.val(lines.join("\n"));
        }
    });
    // Pro end
})

function wbsycf7RunDragDrop() {
    jQuery(document).find(".wbsycf7-column").sortable({
        items: '.wbsycf7-form-row',
        placeholder: 'wbsycf7-sort-placeholder',
        forcePlaceholderSize: true,
        tolerance: 'pointer',
        cancel: '', // ← allow drag on any part of the row
        connectWith: '.wbsycf7-column', // ← enable cross-column dragging
        helper: 'clone',            // smoother drag between containers
    });
}

/* PRO start */
function wbsycf7AddNewPage(that) {    
    let template = jQuery(document).find("#wbsycf7-new-page-template").html();
    jQuery(".wbsycf7-add-new-page").before(template);
    wbsycf7RunDragDrop();    
}

function wbsycf7SetPageTitle() {
    let template = jQuery(document).find("#wbsycf7-pageTitle-template").html();
    let templateFooter = jQuery(document).find("#wbsycf7-pageFooter-template").html();
    const pagesCount = jQuery(document).find(".wbsycf7-page-and-images").length;
    if( pagesCount === 1 ) {
        jQuery(document).find(".wbsycf7-page-and-images .wbsycf7-row-pageTitle").remove();
        jQuery(document).find(".wbsycf7-page-and-images .wbsycf7-row-pageFooter").remove();
    } else {
        jQuery(document).find(".wbsycf7-page-and-images").each(function( index ) {
            if( !jQuery(this).find(".wbsycf7-row-pageTitle").length ) {
                jQuery(this).prepend(template);
            }

            jQuery(this).find(".wbsycf7-row-pageFooter").remove();
            jQuery(this).append(templateFooter);
            if( index === 0 ) {
                jQuery(this).find(".wbsycf7-prevPage-button").remove();
            } else if( index === (pagesCount-1) ) {
                jQuery(this).find(".wbsycf7-nextPage-button").remove();
            }
        });
    }
}


function wbsycf7EditPageTitle() {
    const container = jQuery(document); // or a more specific wrapper

    container.on('click', '.wbsycf7-edit-page-title', function (e) {
        e.stopPropagation();
        jQuery(this).closest(".wbsycf7-row-pageTitle").find(".wbsycf7-page-title").trigger("click");
    });

        // Make page title editable on click
    container.on('click', '.wbsycf7-page-title', function (e) {
        e.stopPropagation();

        const $span = jQuery(this);
        if ($span.data('editing')) return; // already editing

        const initial = $span.text().trim();
        const $row = $span.closest('.wbsycf7-row-page');

         // Build input
        const $input = jQuery('<input type="text" class="wbsycf7-page-title-input" />');
        $input.val(initial);
        console.log(initial);

        // Swap in
        $span.data('editing', true).hide().after($input);
        $input.trigger('focus').select();

        const finish = function (commit) {
            const newVal = ($input.val() || '').toString().trim();
            const finalText = commit ? (newVal || 'Untitled page') : initial;

            $span.text(finalText).show().data('editing', false);
            $input.remove();

            // Fire a custom event if you want to persist the change
            $row.trigger('wbsycf7:pageTitleChanged', { title: finalText, row: $row[0] });
        };

        // Save on Enter, cancel on Esc, save on blur
        $input.on('keydown', function (ev) {
            if (ev.key === 'Enter') {
                ev.preventDefault();
                finish(true);
            } else if (ev.key === 'Escape') {
                ev.preventDefault();
                finish(false);
            }
        }).on('blur', function () {
            finish(true);
        });
    });
}

function toggleFields() {
    const val = jQuery('#wblscf7-success-action').val();
    jQuery('#wblscf7-redirect-field, #wblscf7-message-field').hide();

    if (val === 'redirect') {
        jQuery('#wblscf7-redirect-field').show();
    } else if (val === 'custom_text') {
        jQuery('#wblscf7-message-field').show();
    }
}
/* PRO END */



