<?php
/**
 * Plugin Name: Websinoo Speed Optimizer
 * Plugin URI: https://websinoo.ir/plugins/websinoo-speed-optimizer
 * Description: A lightweight plugin to optimize WordPress speed by enabling caching, Gzip compression, lazy loading, and database optimization.
 * Version: 1.0
 * Author: Mohammad Hasani
 * Author URI: https://websinoo.ir
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.0
 * Tested up to: 6.7
 * Requires PHP: 7.2
 */


// غیرفعال کردن اموجی‌ها و Embeds
function Websinoo_disable_extras() {
    remove_action('wp_head', 'print_emoji_detection_script', 7);
    remove_action('wp_print_styles', 'print_emoji_styles');
    add_filter('emoji_svg_url', '__return_false');
    remove_action('wp_head', 'wp_oembed_add_discovery_links');
    remove_action('wp_head', 'wp_oembed_add_host_js');
}
add_action('init', 'Websinoo_disable_extras');

// افزایش حافظه PHP
function Websinoo_increase_memory_limit() {
    if (!defined('WP_MEMORY_LIMIT')) {
        define('WP_MEMORY_LIMIT', '256M');
    }
    if (!defined('WP_MAX_MEMORY_LIMIT')) {
        define('WP_MAX_MEMORY_LIMIT', '512M');
    }
}
add_action('init', 'Websinoo_increase_memory_limit');

// فعال‌سازی Gzip و کش مرورگر از طریق .htaccess
function Websinoo_optimize_htaccess() {
    $htaccess = ABSPATH . '.htaccess';
    if (is_writable($htaccess)) {
        $rules = "\n# Websinoo Speed Optimizer\n";
        $rules .= "<IfModule mod_deflate.c>\n";
        $rules .= "    AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css text/javascript application/javascript\n";
        $rules .= "</IfModule>\n";
        $rules .= "<IfModule mod_expires.c>\n";
        $rules .= "    ExpiresActive On\n";
        $rules .= "    ExpiresByType image/jpg \"access plus 1 year\"\n";
        $rules .= "    ExpiresByType text/css \"access plus 1 month\"\n";
        $rules .= "</IfModule>\n";
        file_put_contents($htaccess, $rules, FILE_APPEND);
    }
}
register_activation_hook(__FILE__, 'Websinoo_optimize_htaccess');

// بارگذاری تنبل تصاویر (Lazy Load)
function Websinoo_lazy_load($content) {
    return str_replace('<img', '<img loading="lazy"', $content);
}
add_filter('the_content', 'Websinoo_lazy_load');

// غیرفعال کردن Heartbeat API
function Websinoo_disable_heartbeat() {
    wp_deregister_script('heartbeat');
}
add_action('init', 'Websinoo_disable_heartbeat', 1);

// بهینه‌سازی پایگاه داده
function Websinoo_optimize_database() {
    global $wpdb;
    $wpdb->query("DELETE FROM wp_posts WHERE post_type = 'revision'");
    $wpdb->query("DELETE FROM wp_postmeta WHERE meta_key = '_edit_lock'");
    $wpdb->query("OPTIMIZE TABLE wp_posts, wp_postmeta, wp_comments, wp_commentmeta, wp_options, wp_term_relationships, wp_term_taxonomy, wp_terms");
}
add_action('admin_init', 'Websinoo_optimize_database');
