<?php
/**
 * Plugin Name: Webified Weather
 * Plugin URI: https://swordpress.org/plugins/nws-weather
 * Description: Displays current weather conditions using data from the National Weather Service.
 * Version: 2.6
 * Author: webifiedOne
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: webified-weather
 */

defined( 'ABSPATH' ) || exit;

require_once plugin_dir_path( __FILE__ ) . 'includes/class-webiwe-fetcher.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-webiwe-renderer.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/admin-settings.php';

function webiwe_enqueue_styles() {
  wp_enqueue_style(
    'webiwe-style',
    plugin_dir_url( __FILE__ ) . 'includes/webified-style.css',
    [],
    null
  );
}
add_action( 'wp_enqueue_scripts', 'webiwe_enqueue_styles' );

function webiwe_enqueue_scripts() {
  // Reserved for future JavaScript
}
add_action( 'wp_enqueue_scripts', 'webiwe_enqueue_scripts' );

function webiwe_shortcode( $atts ) {
  $atts = shortcode_atts( [
    'lat'   => get_option( 'webiwe_lat', '33.4484' ),
    'lon'   => get_option( 'webiwe_lon', '-112.0740' ),
    'style' => '', // Let override logic handle fallback
  ], $atts );

  $icon_style = !empty( $atts['style'] ) ? $atts['style'] : get_option( 'webiwe_icon_style', 'realistic' );

  $fetcher        = new WEBIWE_Fetcher( $atts['lat'], $atts['lon'] );
  $forecast_data  = $fetcher->get_forecast();
  $current_data   = $fetcher->get_current_conditions();
  $location_name  = $fetcher->get_location_name();

  if ( ! $forecast_data || ! $current_data ) {
    return '<p>Weather data unavailable. Please try refreshing the page.</p>';
  }

  $renderer = new WEBIWE_Renderer();
  return $renderer->render( $forecast_data, $current_data, $location_name, $icon_style );
}
add_shortcode( 'webified_weather', 'webiwe_shortcode' );

function webiwe_plugin_action_links( $links ) {
  $settings_link = '<a href="options-general.php?page=webiwe-settings">Settings</a>';
  array_unshift( $links, $settings_link );
  return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'webiwe_plugin_action_links' );