<?php
class WEBIWE_Renderer {
  public function render( $forecast, $current, $location_name = '', $icon_style = 'realistic' ) {
    $output = '<div class="webified-weather">';

    $page_title = get_the_title();
    if ( $location_name && strpos( strtolower( $page_title ), 'weather' ) === false ) {
      $output .= "<h2>Weather for {$location_name}</h2>";
    }

    if ( ! empty( $current['properties'] ) ) {
      $props     = $current['properties'];
      $desc      = esc_html( $props['textDescription'] );
      $icon      = esc_url( $this->get_custom_icon( $desc, true, $icon_style ) );
      $tempF     = is_numeric( $props['temperature']['value'] ) ? round( ( $props['temperature']['value'] * 9 / 5 ) + 32 ) . '°F' : 'N/A';
      $humidity  = $this->format_value( $props['relativeHumidity']['value'], '%' );
      $pressure  = is_numeric( $props['barometricPressure']['value'] ) ? round( $props['barometricPressure']['value'] / 3386.39, 2 ) . ' inHg' : 'N/A';
      $windSpeed = is_numeric( $props['windSpeed']['value'] ) ? round( $props['windSpeed']['value'] * 2.23694 ) . ' mph' : 'N/A';
      $windDir   = $this->format_value( $props['windDirection']['value'], '°' );

      $output .= "<div class='nws-current'>
                <h3>Current Conditions</h3>
                <img src='{$icon}' alt='{$desc}' />
                <p><strong>{$desc}</strong></p>
                <p style='font-size:2em'><strong>{$tempF}</strong></p>
                <p><strong>Humidity:</strong> {$humidity}</p>
                <p><strong>Pressure:</strong> {$pressure}</p>
                <p><strong>Wind:</strong> {$windDir} at {$windSpeed}</p>
            </div>";
    }

    $output .= "<div class='nws-forecast'><h3>5-Day Forecast</h3>";
    $periods = array_slice( $forecast['properties']['periods'], 0, 10 );
    foreach ( $periods as $period ) {
      $name       = esc_html( $period['name'] );
      $text       = esc_html( $period['detailedForecast'] );
      $short      = esc_html( $period['shortForecast'] );
      $is_daytime = ! empty( $period['isDaytime'] );
      $icon       = esc_url( $this->get_custom_icon( $short, $is_daytime, $icon_style ) );

      $output .= "<div class='nws-text-period'>
                <h4>{$name}</h4>
                <img src='{$icon}' alt='{$short}' />
                <p>{$text}</p>
            </div>";
    }
    $output .= "</div>";

    $output .= '</div>';
    return $output;
  }

  private function format_value( $value, $unit ) {
    return is_numeric( $value ) ? round( $value ) . $unit : 'N/A';
  }

  private function get_custom_icon( $short_forecast, $is_daytime = true, $style = 'realistic' ) {
    $map = [
      'slight chance of rain showers and partly sunny' => [ 'day' => 'partly-cloudy.png', 'night' => 'partly-cloudy-night.png' ],
      'slight chance of showers and thunderstorms'     => [ 'day' => 'thunderstorm.png', 'night' => 'thunderstorm.png' ],
      'a slight chance of rain showers'                => [ 'day' => 'partly-cloudy.png', 'night' => 'partly-cloudy-night.png' ],
      'slight chance of rain'                          => [ 'day' => 'rain.png', 'night' => 'rain.png' ],
      'slight chance t-storms'                         => [ 'day' => 'thunderstorm.png', 'night' => 'thunderstorm.png' ],
      'sunny'                                          => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'mostly sunny'                                   => [ 'day' => 'mostly-sunny.png', 'night' => 'mostly-clear.png' ],
      'partly sunny'                                   => [ 'day' => 'partly-cloudy.png', 'night' => 'partly-cloudy-night.png' ],
      'partly cloudy'                                  => [ 'day' => 'partly-cloudy.png', 'night' => 'partly-cloudy-night.png' ],
      'cloudy'                                         => [ 'day' => 'cloudy.png', 'night' => 'cloudy.png' ],
      'mostly cloudy'                                  => [ 'day' => 'cloudy.png', 'night' => 'cloudy.png' ],
      'overcast'                                       => [ 'day' => 'cloudy.png', 'night' => 'cloudy.png' ],
      'clear'                                          => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'fair'                                           => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'mild'                                           => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'pleasantly warm'                                => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'refreshingly cool'                              => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'hot'                                            => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'very warm'                                      => [ 'day' => 'sun.png', 'night' => 'clear-night.png' ],
      'snow showers'                                   => [ 'day' => 'snow.png', 'night' => 'snow.png' ],
      'rain showers'                                   => [ 'day' => 'rain.png', 'night' => 'rain.png' ],
      'snow'                                           => [ 'day' => 'snow.png', 'night' => 'snow.png' ],
      'rain'                                           => [ 'day' => 'rain.png', 'night' => 'rain.png' ],
      'showers'                                        => [ 'day' => 'rain.png', 'night' => 'rain.png' ],
      'thunderstorm'                                   => [ 'day' => 'thunderstorm.png', 'night' => 'thunderstorm.png' ],
      'fog'                                            => [ 'day' => 'fog.png', 'night' => 'fog.png' ],
      'haze'                                           => [ 'day' => 'haze.png', 'night' => 'haze-night.png' ],
      'smoke'                                          => [ 'day' => 'smoke.png', 'night' => 'smoke-night.png' ],
    ];

    $key = strtolower( trim( $short_forecast ) );

    // Sort keys by length descending to prioritize longer matches
    uksort( $map, function( $a, $b ) {
      return strlen( $b ) - strlen( $a );
    });

    $base_url = plugin_dir_url( dirname( __FILE__ ) );

    foreach ( $map as $pattern => $filenames ) {
      if ( strpos( $key, $pattern ) !== false ) {
        $filename = $is_daytime ? $filenames['day'] : $filenames['night'];
        return $base_url . "assets/icons/{$style}/{$filename}";
      }
    }

    return $base_url . "assets/icons/{$style}/unknown.png";
  }
}