<?php
class WEBIWE_Fetcher {
  private $lat, $lon;

  public function __construct( $lat, $lon ) {
    $this->lat = $lat;
    $this->lon = $lon;
  }

  private function get_request( $url ) {
    $args = [
      'timeout'   => 15,
      'blocking'  => true,
      'sslverify' => false
    ];
    $response = wp_remote_get( $url, $args );
    return is_wp_error( $response ) ? false : json_decode( wp_remote_retrieve_body( $response ), true );
  }

  public function get_forecast() {
    $meta_body = $this->get_request( "https://api.weather.gov/points/{$this->lat},{$this->lon}" );
    if ( empty( $meta_body['properties']['forecast'] ) ) return false;

    $forecast_body = $this->get_request( $meta_body['properties']['forecast'] );
    return $forecast_body ?: false;
  }

  public function get_current_conditions() {
    $meta_body = $this->get_request( "https://api.weather.gov/points/{$this->lat},{$this->lon}" );
    if ( empty( $meta_body['properties']['observationStations'] ) ) return false;

    $stations_body = $this->get_request( $meta_body['properties']['observationStations'] );
    if ( empty( $stations_body['features'][0]['properties']['stationIdentifier'] ) ) return false;

    $station_id = $stations_body['features'][0]['properties']['stationIdentifier'];
    $obs_body   = $this->get_request( "https://api.weather.gov/stations/{$station_id}/observations/latest" );
    return $obs_body ?: false;
  }

  public function get_location_name() {
    $meta_body = $this->get_request( "https://api.weather.gov/points/{$this->lat},{$this->lon}" );
    $location  = $meta_body['properties']['relativeLocation']['properties'] ?? null;

    return ( $location && isset( $location['city'], $location['state'] ) )
      ? sanitize_text_field( "{$location['city']}, {$location['state']}" )
      : false;
  }
}