<?php
function webiwe_settings_menu() {
    add_options_page(
        'Webified Weather Settings',
        'Webified Weather',
        'manage_options',
        'webiwe-settings',
        'webiwe_settings_page'
    );
}
add_action( 'admin_menu', 'webiwe_settings_menu' );

function webiwe_settings_page() {
    ?>
    <div class="wrap">
        <h1>Webified Weather Settings</h1>
        <p><strong>Enter the latitude and longitude of the city/location you want to display. Then, choose an icon style to display.</strong></p>
        <em>Tip: To get latitude and longitude, go to <a href="https://www.weather.gov/" target="_blank">weather.gov</a> and enter a city or location name.
        Then, in your browser's web address field, copy the latitude and longitude to use.</em>

        <form method="post" action="options.php">
            <?php
            settings_fields( 'webiwe_settings_group' );
            do_settings_sections( 'webiwe-settings' );
            submit_button();
            ?>
        </form>

        <div style="margin-top:20px;">
            <p style="font-weight:bold">If you find this plugin helpful, consider supporting its development:</p>
            <a href="https://www.paypal.com/donate?hosted_button_id=S4SWTUDTTZ2N6" target="_blank">
                <img src="https://www.paypalobjects.com/en_US/i/btn/btn_donate_SM.gif" alt="Donate with PayPal button" />
            </a>
        </div>
    </div>
    <?php
}

function webiwe_register_settings() {
    register_setting( 'webiwe_settings_group', 'webiwe_lat', [
        'sanitize_callback' => 'sanitize_text_field'
    ] );

    register_setting( 'webiwe_settings_group', 'webiwe_lon', [
        'sanitize_callback' => 'sanitize_text_field'
    ] );

    register_setting( 'webiwe_settings_group', 'webiwe_icon_style', [
        'sanitize_callback' => 'sanitize_text_field'
    ] );

    add_settings_section( 'webiwe_main', 'Main Settings', null, 'webiwe-settings' );

    add_settings_field( 'webiwe_lat', 'Latitude', 'webiwe_lat_callback', 'webiwe-settings', 'webiwe_main' );
    add_settings_field( 'webiwe_lon', 'Longitude', 'webiwe_lon_callback', 'webiwe-settings', 'webiwe_main' );
    add_settings_field( 'webiwe_icon_style', 'Icon Style', 'webiwe_icon_style_callback', 'webiwe-settings', 'webiwe_main' );
}
add_action( 'admin_init', 'webiwe_register_settings' );

function webiwe_lat_callback() {
    $value = esc_attr( get_option( 'webiwe_lat', '33.4484' ) );
    echo "<input type='text' name='webiwe_lat' value='{$value}' />";
}

function webiwe_lon_callback() {
    $value = esc_attr( get_option( 'webiwe_lon', '-112.0740' ) );
    echo "<input type='text' name='webiwe_lon' value='{$value}' />";
}

function webiwe_icon_style_callback() {
    $value = esc_attr( get_option( 'webiwe_icon_style', 'realistic' ) );
    echo "<select name='webiwe_icon_style'>
        <option value='realistic' " . selected( $value, 'realistic', false ) . ">Realistic</option>
        <option value='flat' " . selected( $value, 'flat', false ) . ">Flat</option>
        <option value='mono' " . selected( $value, 'mono', false ) . ">Monochrome</option>
    </select>";
}