<?php
/**
 * Webhookify Uninstall
 *
 * Uninstalling Webhookify deletes plugin options.
 *
 * @package Webhookify
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('webhookify_settings');

// For multisite installations
delete_site_option('webhookify_settings');

// Clear any cached data
wp_cache_flush();
