jQuery(document).ready(function($) {
    $('body').on('click', '.wts-upload-logo-button', function(e) {
        e.preventDefault();

        var button = $(this);
        var inputField = button.prev('.wts-logo-url-input');
        var previewContainer = button.closest('.wts-logo-uploader').find('.wts-logo-preview');

        var frame = wp.media({
            title: 'Select or upload the bot logo',
            button: {
                text: 'Use this logo'
            },
            multiple: false
        });

        frame.on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            inputField.val(attachment.url);
            previewContainer.html('<img src="' + attachment.url + '" alt="Logo preview" style="max-width:100%;">');
        });

        frame.open();
    });

    $('body').on('click', '.wts-remove-logo-button', function(e) {
        e.preventDefault();
        var button = $(this);
        var inputField = button.siblings('.wts-logo-url-input');
        var previewContainer = button.closest('.wts-logo-uploader').find('.wts-logo-preview');

        inputField.val('');
        previewContainer.html('');
    });
});