document.addEventListener('DOMContentLoaded', function () {
    var swiper = new Swiper('.swiper', {
        loop: false,
        slidesPerView: 4, // Set this based on your design
        spaceBetween: 10, // Adjust based on your needs
        autoplay: {
            delay: 3000,
        },
        breakpoints: {
            // When the screen width is 1200px or more (large screens)
            1200: {
                slidesPerView: 4, // Show 4 cards per view on large screens
            },
            // When the screen width is between 768px and 1199px (tablet screens)
            768: {
                slidesPerView: 3, // Show 3 cards per view on medium screens
            },
            // When the screen width is between 576px and 767px (small tablets or large phones)
            576: {
                slidesPerView: 2, // Show 2 cards per view on small screens
            },
            // When the screen width is 575px or less (mobile screens)
            0: {
                slidesPerView: 1, // Show 1 card per view on very small screens
            }
        }
    });
});
