<?php
/**
 * Initialize file.
 *
 * @package we-subscription
 *
 * Plugin Name: WE Subscription
 * Plugin URI:        http://webeffortless.com/plugins/we-subscription/
 * Description:       Sell your product with recurring payments
 * Version:           1.0.0
 * Requires at least: 5.5
 * Requires PHP:      7.4
 * WC tested up to:   10.4.3
 * WC requires at least: 5.5.0
 * Author:            WebEffortless
 * Author URI:        http://webeffortless.com/
 * License:           GPL v3 or later
 * License URI:       http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       we-subscription
 * Domain Path:       /languages
 * Requires Plugins:  woocommerce
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!function_exists('is_plugin_active')) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}
if (!is_plugin_active('woocommerce/woocommerce.php')) {
	add_action('admin_notices', 'wesub_plugin_deactivate');

	/**
	 * Deactivate plugin.
	 *
	 * @since 1.0.0
	 * @name wesub_plugin_deactivate
	 */
	function wesub_plugin_deactivate()
	{
		?>
		<div class="error notice is-dismissible">
			<p><?php esc_html_e('WooCommerce Must be activated before using the WebEffortless\'s Subscription For WooCommerce', 'we-subscription'); ?>
			</p>
		</div>
		<?php
	}
	return;
}
!defined('WESUB_URL') && define('WESUB_URL', plugin_dir_url(__FILE__));
!defined('WESUB_PATH') && define('WESUB_PATH', plugin_dir_path(__FILE__));
!defined('WESUB_VERSION') && define('WESUB_VERSION', '1.0.0');


if (!class_exists('Wesub_Autoloader')) {
	require_once WESUB_PATH . 'includes/class-wesub-autoloader.php';
}

// Add settings link on plugin page.
add_filter(
	'plugin_action_links_' . plugin_basename(__FILE__),
	function ($links) {
		$my_link = array(
			'<a href="' . admin_url('admin.php?page=wesub-subscription') . '">' . __('Settings', 'we-subscription') . '</a>',
			'<a href="http://webeffortless.com/support" target="_blank">' . __('Support', 'we-subscription') . '</a>',
		);
		return array_merge($my_link, $links);
	}
);

add_action(
	'before_woocommerce_init',
	function () {
		if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
		}
		if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
		}
	}
);
