jQuery(function(){
	if ( ! window.wc ) {
		return;
	}
	var { registerCheckoutFilters } = window.wc.blocksCheckout;

	const wesSubtotalPriceFormat = (
		defaultValue,
		extensions,
		args,
		validation
	) => {
		const isCartContext = args?.context === 'cart';
		
		if ( ! isCartContext ) {
			return defaultValue;
		}
	    const cartItem = args?.cartItem.item_data;

		if ( cartItem && cartItem != undefined && cartItem.find( item => item.name === 'wesub-price-html') ){
	     	planPrice = cartItem.find( item => item.name === 'wesub-price-html');
			return defaultValue + planPrice?.value;
		}
		return defaultValue;
	};

	const wesPlaceOrderButtonLabel = ( defaultValue, extensions, args ) => {

		if ( wesub_block.button_text ) {
			return wesub_block.button_text;
		}
		return defaultValue;
	};
	
	registerCheckoutFilters( 'wesub-wc-block', {
		subtotalPriceFormat: wesSubtotalPriceFormat,
		placeOrderButtonLabel: wesPlaceOrderButtonLabel,
	} );
});