<?php
/**
 * Uninstall script for WebEffortless WooCommerce Subscription
 *
 * This file is executed when the plugin is deleted via the WordPress admin.
 * It removes all plugin data from the database.
 *
 * @package we-subscription
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove user meta related to subscriptions
global $wpdb;

// Clean up any scheduled actions related to subscriptions
$wpdb->query("DELETE FROM {$wpdb->prefix}actionscheduler_actions WHERE hook LIKE 'wesub_%'");
$wpdb->query("DELETE FROM {$wpdb->prefix}actionscheduler_logs WHERE action_id NOT IN (SELECT action_id FROM {$wpdb->prefix}actionscheduler_actions)");
$wpdb->query("DELETE FROM {$wpdb->prefix}actionscheduler_claims WHERE action_id NOT IN (SELECT action_id FROM {$wpdb->prefix}actionscheduler_actions)");


// Clear any cached data
wp_cache_flush();
