<?php
/**
 * Display the subscription list
 *
 * @package    we-subscription
 * @subpackage we-subscription/templates
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<table class="shop_table shop_table_responsive we-subscription-list">
	<thead>
		<tr>
			<th><?php esc_attr_e('ID', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Status', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Payment Method', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Next Renewal', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Expiry', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Total', 'we-subscription'); ?></th>
			<th></th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<?php
			$wesub_user_id = get_current_user_id(); // Get the current user's ID.
			
			// Query arguments for getting orders.
			$wesub_args = array(
				'type' => 'wesub_subscriptions',
				'customer' => $wesub_user_id, // Filter orders by customer ID.
				'return' => 'ids',
			);
			// Get subscriptions.
			$wesub_subscriptions = wc_get_orders($wesub_args);

			if (!empty($wesub_subscriptions)) {
				foreach ($wesub_subscriptions as $wesub_subscription_id) {
					$wesub_subscription = new Wesub_Subscription($wesub_subscription_id);
					echo '<tr>';
					echo '<td>' . esc_attr($wesub_subscription_id) . '</td>';
					$status = $wesub_subscription->get_meta('wesub_status');
					echo '<td><span class="wesub-status-badge status-' . esc_attr($status) . '">' . esc_attr(ucfirst($status)) . '</span></td>';
					echo '<td>' . esc_attr($wesub_subscription->get_payment_method_title()) . '</td>';
					echo '<td>' . esc_attr($wesub_subscription->get_meta('wesub_next_renewal') ? date_i18n(wc_date_format(), $wesub_subscription->get_meta('wesub_next_renewal')) : '---') . '</td>';
					echo '<td>' . esc_attr($wesub_subscription->get_meta('wesub_expire_date') ? date_i18n(wc_date_format(), $wesub_subscription->get_meta('wesub_expire_date')) : '---') . '</td>';
					echo '<td>' . wp_kses_post(wc_price($wesub_subscription->get_total())) . '</td>';
					echo '<td><a href="' . esc_url(wc_get_endpoint_url('view-subscription', $wesub_subscription_id, wc_get_page_permalink('myaccount'))) . '"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye" style="vertical-align: text-bottom; margin-right: 5px;"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></a></td>';
					echo '</tr>';
				}
			} else {
				?>
				<tr>
					<td colspan="7"><?php esc_attr_e('Subscriptions not found', 'we-subscription'); ?></td>
				</tr>
				<?php
			}
			?>
	</tbody>
</table>