<?php
/**
 * Subscription Details.
 *
 * @link       https://webeffortless.com/
 * @since      1.0.0
 *
 * @package    we-subscription
 * @subpackage we-subscription/templates
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$wesub_subscription = new Wesub_Subscription($wesub_subscription_id);
?>
<h1><?php esc_attr_e('Subscription', 'we-subscription'); ?> #<?php echo esc_attr($wesub_subscription_id); ?></h1>

<div class="we-subscription-card">
	<table class="shop_table we-subscription-details-summary">
		<tr>
			<th><?php esc_attr_e('Status', 'we-subscription'); ?></th>
			<td><span
					class="wesub-status-badge status-<?php echo esc_attr($wesub_subscription->get_meta('wesub_status')); ?>"><?php echo esc_attr(ucfirst($wesub_subscription->get_meta('wesub_status'))); ?></span>
			</td>
		</tr>
		<tr>
			<th><?php esc_attr_e('Parent ID', 'we-subscription'); ?></th>
			<td><?php echo esc_attr($wesub_subscription->get_meta('wesub_parent_order_id')); ?></td>
		</tr>
		<tr>
			<th><?php esc_attr_e('Payment Method', 'we-subscription'); ?></th>
			<td><?php echo esc_attr($wesub_subscription->get_payment_method_title()); ?></td>
		</tr>
		<tr>
			<th><?php esc_attr_e('Next Renewal Date', 'we-subscription'); ?></th>
			<td><?php echo ($wesub_subscription->get_meta('wesub_next_renewal') ? esc_attr(date_i18n(wc_date_format(), $wesub_subscription->get_meta('wesub_next_renewal'))) : '---'); ?>
			</td>
		</tr>
		<tr>
			<th><?php esc_attr_e('Expiration', 'we-subscription'); ?></th>
			<td><?php echo ($wesub_subscription->get_meta('wesub_expire_date') ? esc_attr(date_i18n(wc_date_format(), $wesub_subscription->get_meta('wesub_expire_date'))) : '---'); ?>
			</td>
		</tr>
		<?php $wesub_get_settings = get_option('wesub_settings', array());
		$wesub_subscription_status = $wesub_subscription->get_meta('wesub_status');
		if (!empty($wesub_get_settings) && isset($wesub_get_settings['user_can_cancel']) && 'on' === $wesub_get_settings['user_can_cancel'] && 'cancelled' !== $wesub_subscription_status) {
			?>
						<tr>
							<th><?php esc_attr_e('Actions', 'we-subscription'); ?></th>
							<td>
								<?php
								$wesub_cancel_link = add_query_arg(
									array(
										'wesub_subscription_id' => $wesub_subscription_id,
										'action' => 'cancel',
									)
								);
								$wesub_cancel_link = wp_nonce_url($wesub_cancel_link, $wesub_subscription_id);

								$wesub_change_payment_link = add_query_arg(
									array(
										'wesub_subscription_id' => $wesub_subscription_id,
										'change_payment_method' => 'true',
										'_wpnonce' => wp_create_nonce('wesub_change_payment_' . $wesub_subscription_id),
									),
									$wesub_change_payment_link
								);
								?>
								<a class="button btn"
									href="<?php echo esc_attr($wesub_cancel_link); ?>"><?php esc_attr_e('Cancel', 'we-subscription'); ?></a>
								<a class="button btn wesub-change-payment-btn"
									href="<?php echo esc_url($wesub_change_payment_link); ?>"><?php esc_attr_e('Change Payment Method', 'we-subscription'); ?></a>
								<?php
								do_action('wesub_add_more_actions', $wesub_subscription_id);
								?>
							</td>
						</tr>
		<?php } ?>
	</table>
</div>

<div class="we-subscription-card">
	<h3><?php esc_attr_e('Subscription Details', 'we-subscription'); ?></h3>
	<table class="shop_table shop_table_responsive we-subscription-details-items">
		<tr>
			<th><?php esc_attr_e('Product', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Cost', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Qty', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Tax', 'we-subscription'); ?></th>
			<th><?php esc_attr_e('Total', 'we-subscription'); ?></th>
		</tr>
		<?php
		$wesub_product_id = 0;
		foreach ($wesub_subscription->get_items('line_item') as $wesub_item_id => $wesub_item):
			$wesub_product_id = $wesub_item->get_product_id();
			?>
						<tr>
							<td><?php echo esc_attr($wesub_item->get_name()); ?></td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_subtotal())); ?></td>
							<td><?php echo esc_attr($wesub_item->get_quantity()); ?></td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total_tax())); ?></td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total())); ?></td>
						</tr>
		<?php endforeach; ?>
		<?php
		foreach ($wesub_subscription->get_items('fee') as $wesub_item_id => $wesub_item):
			?>
						<tr>
							<td><?php echo esc_attr($wesub_item->get_name()); ?></td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total())); ?></td>
							<td>-</td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total_tax())); ?></td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total())); ?></td>
						</tr>
		<?php endforeach; ?>
		<?php
		foreach ($wesub_subscription->get_items('shipping') as $wesub_item_id => $wesub_item):
			?>
						<tr>
							<td><?php echo esc_attr($wesub_item->get_name()); ?></td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total())); ?></td>
							<td>-</td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total_tax())); ?></td>
							<td><?php echo wp_kses_post(wc_price($wesub_item->get_total())); ?></td>
						</tr>
		<?php endforeach; ?>
		<?php do_action('wesub_after_subscription_line_item', $wesub_subscription); ?>
		<tr>
			<th colspan="4"><?php esc_attr_e('Subtotal', 'we-subscription'); ?></th>
			<td><?php echo wp_kses_post(wc_price($wesub_subscription->get_subtotal())); ?></td>
		</tr>
		<tr>
			<th colspan="4"><?php esc_attr_e('Total', 'we-subscription'); ?></th>
			<td><?php echo wp_kses_post(wesub_product_price_html(wc_price($wesub_subscription->get_total()), $wesub_product_id)); ?>
			</td>
		</tr>
	</table>
</div>

<div class="we-subscription-card">
	<h3><?php esc_attr_e('Renewal Orders', 'we-subscription'); ?></h3>
	<table class="shop_table shop_table_responsive we-subscription-details-related">
		<?php
		// Check if HPOS is enabled.
		if (wesub_is_hpos_enabled()) {
			$wesub_args = array(
				'limit' => -1,
				'return' => 'ids',
				'meta_query' => array(
					array(
						'key' => 'wesub_subscription_id',
						'value' => $wesub_subscription_id,
						'compare' => '=',  // Ensure the comparison is equality.
					),
				),
			);
			$wesub_renewal_orders = wc_get_orders($wesub_args);

		} else {
			$wesub_args = array(
				'numberposts' => -1,
				'meta_query' => array(
					array(
						'key' => 'wesub_subscription_id',
						'value' => $wesub_subscription_id,
						'compare' => '=',  // Ensure the comparison is equality.
					),
				),
			);
			$wesub_renewal_orders = get_posts($wesub_args);
		}
		?>
		<tr>
			<th><?php echo esc_attr('Order', 'we-subscription'); ?></th>
			<th><?php echo esc_attr('Date', 'we-subscription'); ?></th>
			<th><?php echo esc_attr('Status', 'we-subscription'); ?></th>
			<th><?php echo esc_attr('Total', 'we-subscription'); ?></th>

			<?php
			if (is_array($wesub_renewal_orders) && !empty($wesub_renewal_orders)) {
				foreach ($wesub_renewal_orders as $wesub_key => $wesub_value) {

					if (wesub_is_hpos_enabled()) {
						$wesub_renewal_id = $wesub_value;
					} else {
						$wesub_renewal_id = $wesub_value->ID;
					}
					$wesub_renewal_order = wc_get_order($wesub_renewal_id);

					$wesub_date_created = $wesub_renewal_order->get_date_created();
					if ($wesub_date_created) {
						$wesub_date_created = $wesub_date_created->date(wc_date_format());
					}
					?>
										<tr>
											<td><?php echo '#' . esc_attr($wesub_renewal_id); ?></td>
											<td><?php echo esc_attr($wesub_date_created); ?></td>
											<td><?php echo esc_attr($wesub_renewal_order->get_status()); ?></td>
											<td><?php echo wp_kses_post(wc_price($wesub_subscription->get_total())); ?></td>
										</tr>
										<?php
				}
				?>
						</tr>
						<?php
			} else {
				?>
						<tr>
							<td colspan="4"><?php esc_html_e('Renewals not found', 'we-subscription'); ?></td>
						</tr>
						<?php
			}
			?>
	</table>
</div>