<?php
/**
 * WebEffortless Welcome Page
 *
 * @link       https://webeffortless.com/
 * @since      1.0.0
 *
 * @package    we-subscription
 * @subpackage we-subscription/templates/admin
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
?>
<div class="wrap wesub-welcome-wrap">
    <div class="wesub-welcome-header">
        <h1>
            <?php esc_html_e('Welcome to WebEffortless', 'we-subscription'); ?>
        </h1>
        <p class="wesub-welcome-subtitle">
            <?php esc_html_e('Powerful WordPress & WooCommerce Solutions', 'we-subscription'); ?>
        </p>
    </div>

    <div class="wesub-welcome-content">
        <div class="wesub-welcome-section">
            <div class="wesub-welcome-card wesub-brand-card">
                <div class="wesub-brand-icon">
                    <span class="dashicons dashicons-admin-generic"></span>
                </div>
                <h2>
                    <?php esc_html_e('About WebEffortless', 'we-subscription'); ?>
                </h2>
                <p>
                    <?php esc_html_e('WebEffortless is dedicated to creating high-quality, user-friendly WordPress and WooCommerce plugins that help businesses grow and succeed online. Our mission is to make powerful e-commerce features accessible and easy to use for everyone.', 'we-subscription'); ?>
                </p>
            </div>

            <div class="wesub-welcome-grid">
                <div class="wesub-welcome-card">
                    <span class="dashicons dashicons-cart"></span>
                    <h3>
                        <?php esc_html_e('WooCommerce Subscription', 'we-subscription'); ?>
                    </h3>
                    <p>
                        <?php esc_html_e('Create and manage recurring payment subscriptions with ease. Support for multiple payment gateways, automatic renewals, and comprehensive subscription management.', 'we-subscription'); ?>
                    </p>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=wesub-subscription')); ?>"
                        class="button button-primary">
                        <?php esc_html_e('Manage Subscriptions', 'we-subscription'); ?>
                    </a>
                </div>

                <div class="wesub-welcome-card">
                    <span class="dashicons dashicons-admin-users"></span>
                    <h3>
                        <?php esc_html_e('User Management', 'we-subscription'); ?>
                    </h3>
                    <p>
                        <?php esc_html_e('Automatically assign user roles based on subscription status, manage access control, and provide seamless customer experiences.', 'we-subscription'); ?>
                    </p>
                </div>

                <div class="wesub-welcome-card">
                    <span class="dashicons dashicons-update"></span>
                    <h3>
                        <?php esc_html_e('Automatic Renewals', 'we-subscription'); ?>
                    </h3>
                    <p>
                        <?php esc_html_e('Set up automatic payment processing for subscription renewals with retry logic for failed payments and comprehensive notification system.', 'we-subscription'); ?>
                    </p>
                </div>

                <div class="wesub-welcome-card">
                    <span class="dashicons dashicons-chart-line"></span>
                    <h3>
                        <?php esc_html_e('Analytics & Reports', 'we-subscription'); ?>
                        <span class="wesub-coming-soon-badge">
                            <?php esc_html_e('Coming Soon', 'we-subscription'); ?>
                        </span>
                    </h3>
                    <p>
                        <?php esc_html_e('Track subscription metrics, monitor revenue, and gain insights into your subscription business with detailed reporting tools.', 'we-subscription'); ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="wesub-welcome-section wesub-support-section">
            <div class="wesub-welcome-card wesub-support-card">
                <h2>
                    <?php esc_html_e('Need Help?', 'we-subscription'); ?>
                </h2>
                <p>
                    <?php esc_html_e('Our support team is here to help you get the most out of your WebEffortless plugins.', 'we-subscription'); ?>
                </p>
                <div class="wesub-support-links">
                    <a href="https://webeffortless.com/support" target="_blank" class="button button-secondary">
                        <span class="dashicons dashicons-sos"></span>
                        <?php esc_html_e('Get Support', 'we-subscription'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="wesub-welcome-footer">
        <p>
            <?php
            printf(
                /* translators: %s: WebEffortless website URL */
                esc_html__('Made with ❤️ by %s', 'we-subscription'),
                '<a href="https://webeffortless.com" target="_blank">WebEffortless</a>'
            );
            ?>
        </p>
    </div>
</div>