<?php
/**
 * Register the admin setting
 *
 * @package    we-subscription
 * @subpackage we-subscription/templates
 */

defined('ABSPATH') || exit; // Exit if accessed directly.

$wesub_active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'subscription';

// Ensure WESUB_Table_List is available
if (!class_exists('WESUB_Table_List')) {
	require_once WESUB_PATH . 'includes/admin/class-wesub-table-list.php';
}
?>
<div class="wesub-wrap">
	<div class="wesub-header-container">
		<h2 class="nav-tab-wrapper">
			<a href="?page=wesub-subscription&tab=subscription"
				class="nav-tab <?php echo 'subscription' === $wesub_active_tab ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Subscriptions', 'we-subscription'); ?></a>
			<a href="?page=wesub-subscription&tab=settings"
				class="nav-tab <?php echo 'settings' === $wesub_active_tab ? 'nav-tab-active' : ''; ?>"><?php esc_html_e('Settings', 'we-subscription'); ?></a>
		</h2>
		<div class="wesub-header-actions">
			<a href="http://webeffortless.com/support" target="_blank" class="wesub-support-link">
				<span class="dashicons dashicons-sos"></span>
				<?php esc_html_e('Get Support', 'we-subscription'); ?>
			</a>
			<span class="wesub-version">
				<?php echo esc_attr('v' . WESUB_VERSION); ?>
			</span>
		</div>
	</div>

	<?php if ('subscription' === $wesub_active_tab): ?>
		<form method="post">
			<?php
			wp_nonce_field('wesub_bulk_action', 'wesub_bulk_nonce');
			$wesub_list_table = new WESUB_Table_List();
			$wesub_list_table->prepare_items();
			$wesub_list_table->search_box(esc_attr__('Search', 'we-subscription'), 'wesub_id');
			$wesub_list_table->display();
			?>
		</form>
		<!-- Renewals Modal Container -->
		<div id="wesub-renewals-modal" class="wesub-modal">
			<div class="wesub-modal-content">
				<span class="wesub-close">&times;</span>
				<h2><?php esc_html_e('Renewal Orders', 'we-subscription'); ?></h2>
				<div id="wesub-modal-body"></div>
			</div>
		</div>
	<?php else: ?>
		<?php $wesub_settings = get_option('wesub_settings', array()); ?>
		<form id="we-settings-form">


			<div class="wesub-grid">
				<!-- Button Text Settings -->
				<div class="wesub-card">
					<h2><span class="dashicons dashicons-editor-textcolor"></span>
						<?php esc_html_e('Button Text', 'we-subscription'); ?></h2>
					<section>
						<div class="wesub-form-group">
							<label
								for="we-add-to-cart-button-text"><?php esc_html_e('Add to Cart Text', 'we-subscription'); ?></label>
							<input type="text" id="we-add-to-cart-button-text" name="we-add-to-cart-button-text"
								value="<?php echo isset($wesub_settings['add_to_cart_button_text']) ? esc_attr($wesub_settings['add_to_cart_button_text']) : esc_attr__('Add To Cart', 'we-subscription'); ?>" />
						</div>
						<div class="wesub-form-group">
							<label
								for="we-place-order-text"><?php esc_html_e('Place Order Text', 'we-subscription'); ?></label>
							<input type="text" id="we-place-order-text" name="we-place-order-text"
								value="<?php echo isset($wesub_settings['place_order_text']) ? esc_attr($wesub_settings['place_order_text']) : esc_attr__('Place Order', 'we-subscription'); ?>" />
						</div>
					</section>
				</div>

				<!-- User Roles -->
				<div class="wesub-card">
					<h2><span class="dashicons dashicons-admin-users"></span>
						<?php esc_html_e('User Roles', 'we-subscription'); ?></h2>
					<section>
						<div class="wesub-form-group">
							<label
								for="we-assign-user-role"><?php esc_html_e('Subscriber Role', 'we-subscription'); ?></label>
							<select id="we-assign-user-role" name="we-assign-user-role">
								<option value=""><?php esc_html_e('Select a role...', 'we-subscription'); ?></option>
								<?php foreach (get_editable_roles() as $wesub_role_key => $wesub_available_role): ?>
									<option value="<?php echo esc_attr($wesub_role_key); ?>" <?php selected(isset($wesub_settings['assign_user_role']) ? $wesub_settings['assign_user_role'] : null, $wesub_role_key); ?>>
										<?php echo esc_attr($wesub_available_role['name']); ?>
									</option>
								<?php endforeach; ?>
							</select>
							<p class="wesub-description">
								<?php esc_html_e('This role will be assigned to the user when they purchase a subscription.', 'we-subscription'); ?>
							</p>
						</div>
						<div class="wesub-form-group">
							<label><?php esc_html_e('Remove Role on Cancellation', 'we-subscription'); ?></label>
							<label class="switch">
								<input type="checkbox" id="we-remove-assign-user-role" name="we-remove-assign-user-role"
									<?php checked(isset($wesub_settings['remove_assign_user_role']) ? $wesub_settings['remove_assign_user_role'] : null, 'on'); ?> />
								<span class="slider round"></span>
							</label>
							<p class="wesub-description">
								<?php esc_html_e('If enabled, the assigned role will be removed when the subscription is cancelled or expires, unless the user has other active subscriptions.', 'we-subscription'); ?>
							</p>
						</div>
					</section>
				</div>

				<!-- Renewals -->
				<div class="wesub-card">
					<h2><span class="dashicons dashicons-update"></span> <?php esc_html_e('Renewals', 'we-subscription'); ?>
					</h2>
					<section>
						<div class="wesub-form-group">
							<label><?php esc_html_e('Enable Manual Renewals', 'we-subscription'); ?></label>
							<label class="switch">
								<input type="checkbox" id="we-manual-renewal-payment" name="we-manual-renewal-payment" <?php checked(isset($wesub_settings['manual_payment']) ? $wesub_settings['manual_payment'] : null, 'on'); ?> />
								<span class="slider round"></span>
							</label>
						</div>
						<div class="wesub-form-group" id="wesub-retry-section">
							<label><?php esc_html_e('Retry Failed Payments', 'we-subscription'); ?></label>
							<label class="switch">
								<input type="checkbox" id="we-retry-failed-renewals" name="we-retry-failed-renewals" <?php checked(isset($wesub_settings['retry_failed_renewals']) ? $wesub_settings['retry_failed_renewals'] : null, 'on'); ?> />
								<span class="slider round"></span>
							</label>
						</div>
					</section>
				</div>

				<!-- Advance Settings -->
				<div class="wesub-card">
					<h2><span class="dashicons dashicons-admin-settings"></span>
						<?php esc_html_e('Advanced', 'we-subscription'); ?></h2>
					<section>
						<div class="wesub-form-group">
							<label><?php esc_html_e('Multiple Subscriptions at Checkout', 'we-subscription'); ?></label>
							<label class="switch">
								<input type="checkbox" id="we-multiple-product-purchases"
									name="we-multiple-product-purchases" <?php checked(isset($wesub_settings['multiple_product_purchases']) ? $wesub_settings['multiple_product_purchases'] : null, 'on'); ?> />
								<span class="slider round"></span>
							</label>
							<p class="wesub-description">
								<?php esc_html_e('Allow users to purchase multiple subscriptions and products at checkout.', 'we-subscription'); ?>
							</p>

						</div>
						<div class="wesub-form-group">
							<label><?php esc_html_e('Allow User Cancellation', 'we-subscription'); ?></label>
							<label class="switch">
								<input type="checkbox" id="we-user-can-cancel" name="we-user-can-cancel" <?php checked(isset($wesub_settings['user_can_cancel']) ? $wesub_settings['user_can_cancel'] : null, 'on'); ?> />
								<span class="slider round"></span>
							</label>
						</div>
						<div class="wesub-form-group">
							<label><?php esc_html_e('Enable Debug Logging', 'we-subscription'); ?></label>
							<label class="switch">
								<input type="checkbox" id="wesub-log" name="wesub-log" <?php checked(isset($wesub_settings['wesub_log']) ? $wesub_settings['wesub_log'] : null, 'on'); ?> />
								<span class="slider round"></span>
							</label>
						</div>
					</section>
				</div>
			</div>

			<div class="wesub-actions">
				<input type="submit" class="button" name="we-save-settings"
					value="<?php esc_attr_e('Save Changes', 'we-subscription'); ?>" />
			</div>
		</form>
	<?php endif; ?>
</div>