<?php
/**
 * This function will register custom subscription order type and register menu.
 *
 * @since 1.0.0
 * @package    we-subscription
 * @subpackage we-subscription/includes
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Register WESUB_Subscription Order Type
 */
function wesub_order_type()
{
	if (function_exists('wc_register_order_type')) {
		wc_register_order_type(
			'wesub_subscriptions',
			apply_filters(
				'wesub_order_type_args',
				array(
					'labels' => array(
						'name' => __('WE Subscriptions', 'we-subscription'),
						'singular_name' => __('WE Subscription', 'we-subscription'),
						'add_new' => __('Add WE Subscription', 'we-subscription'),
						'add_new_item' => __('Add New WE Subscription', 'we-subscription'),
						'edit' => __('Edit', 'we-subscription'),
						'edit_item' => __('Edit WE Subscription', 'we-subscription'),
						'new_item' => __('New WE Subscription', 'we-subscription'),
						'view' => __('View WE Subscription', 'we-subscription'),
						'view_item' => __('View WE Subscription', 'we-subscription'),
						'search_items' => __('Search WE Subscriptions', 'we-subscription'),
						'not_found' => __('Not Found', 'we-subscription'),
						'not_found_in_trash' => __('No WE Subscriptions found in the trash', 'we-subscription'),
						'parent' => __('Parent WE Subscriptions', 'we-subscription'),
						'menu_name' => __('WE Subscriptions List', 'we-subscription'),
					),
					'description' => __('This is where WE subscriptions are stored.', 'we-subscription'),
					'public' => false,
					'show_ui' => true,
					'capability_type' => 'shop_order',
					'publicly_queryable' => false,
					'exclude_from_search' => true,
					'show_in_menu' => false,
					'hierarchical' => false,
					'show_in_nav_menus' => false,
					'rewrite' => false,
					'query_var' => false,
					'supports' => array('title', 'comments', 'custom-fields'),
					'has_archive' => false,
					'exclude_from_orders_screen' => true,
					'add_order_meta_boxes' => true,
					'exclude_from_order_count' => true,
					'exclude_from_order_views' => true,
					'exclude_from_order_webhooks' => true,
					'exclude_from_order_reports' => true,
					'exclude_from_order_sales_reports' => true,
					'class_name' => 'Wesub_Subscription',
					'menu_icon' => 'dashicons-cart',
				)
			)
		);
	}
}
add_action('init', 'wesub_order_type');

