<?php
/**
 * The file that defines the main WPS_Subscription class
 *
 * @link  https://webeffortless.com/
 * @since 1.0.0
 *
 * @package    we-subscription
 * @subpackage we-subscription/includes
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
	exit;
}

/**
 * Main payment class.
 *
 * This is used to extend the WC_Order class.
 *
 * @since      1.0.0
 * @package    we-subscription
 * @subpackage we-subscription/includes
 */
class Wesub_Subscription extends WC_Order
{

	/**
	 * Store the order data
	 *
	 * @public WC_Order Stores order data for the order in which the subscription was purchased (if any)
	 * @var bool
	 */
	protected $order = null;

	/**
	 * Store the order type
	 *
	 * @public string Order type
	 * @var bool
	 */
	public $order_type = 'wesub_subscriptions';

	/**
	 * Store the order data
	 *
	 * @private int Stores get_payment_count when used multiple times
	 * @var bool
	 */
	private $cached_payment_count = null;

	/**
	 * This is the name of this object type. WC 3.0+ property.
	 *
	 * @var string
	 */
	protected $object_type = 'subscription';


	/**
	 * Store the order data
	 *
	 * Stores the $this->is_editable() returned value in memory
	 *
	 * @var bool
	 */
	private $editable;

	/**
	 * Store the order data
	 *
	 * @private array The set of valid date types that can be set on the subscription
	 * @var bool
	 */
	protected $valid_date_types = array();

	/**
	 * Initializes a specific subscription if the ID is passed, otherwise a new and empty instance of a subscription.
	 *
	 * This class should NOT be instantiated, instead the functions wcs_create_subscription() and wcs_get_subscription()
	 * should be used.
	 *
	 * @param int|WPS_Subscription $wesub_subscription Subscription to read.
	 */
	public function __construct($wesub_subscription = 0)
	{

		parent::__construct($wesub_subscription);
		$this->order_type = 'wesub_subscriptions';
	}

	/**
	 * Get internal type.
	 *
	 * @return string
	 */
	public function get_type()
	{
		return 'wesub_subscriptions';
	}
	/**
	 * Added this function to avoid the critical error.
	 *
	 * @return null
	 */
	public function get_report_customer_id()
	{
		return null;
	}
}
