<?php
/**
 * Handle the subscription Product and it's setting
 *
 * @class Wesub_Settings
 * @package    we-subscription
 * @subpackage we-subscription/includes/admin
 */

defined('ABSPATH') || exit; // Exit if accessed directly.

if (!class_exists('Wesub_Settings')) {
	/**
	 * Wesub_Settings
	 */
	class Wesub_Settings
	{
		/**
		 * The single instance of the class.
		 *
		 * @var Wesub_Settings
		 */
		private static $instance;

		/**
		 * Current class instance
		 */
		public static function instance()
		{
			return !is_null(self::$instance) ? self::$instance : self::$instance = new self();
		}

		/**
		 * Contructor
		 */
		public function __construct()
		{
			// Register Submenu and its section.
			add_action('admin_menu', array($this, 'register_submenu'));

			add_action('wp_ajax_wesub_handle_setting_form_submission', array($this, 'wesub_handle_setting_form_submission'));

			// Enqueue admin styles
			add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_styles'));
		}

		/**
		 * Enqueue admin styles
		 */
		public function enqueue_admin_styles($hook)
		{
			// Only load on our welcome page
			if ($hook === 'toplevel_page_webeffortless') {
				wp_enqueue_style(
					'wesub-welcome-page',
					WESUB_URL . 'assets/admin/css/we-welcome-page.css',
					array(),
					WESUB_VERSION
				);
			}
		}

		/**
		 * Register a top-level menu and submenu
		 */
		public function register_submenu()
		{
			// Allow other plugins to indicate if the WebEffortless menu already exists
			$menu_exists = apply_filters('wesub_menu_exists', false);

			// If no other plugin has registered the menu, check manually
			if (!$menu_exists) {
				global $menu;
				if (!empty($menu)) {
					foreach ($menu as $wesub_item) {
						if (isset($wesub_item[2]) && $wesub_item[2] === 'webeffortless') {
							$menu_exists = true;
							break;
						}
					}
				}
			}

			// Add top-level menu only if it doesn't exist
			if (!$menu_exists) {
				add_menu_page(
					'WebEffortless', // Page title
					'WebEffortless', // Menu title
					'manage_options', // Capability required
					'webeffortless', // Menu slug
					array($this, 'welcome_page_content'), // Callback for welcome page
					'dashicons-admin-generic', // Icon
					56 // Position (after WooCommerce which is at 55)
				);

				// Let other plugins know the menu has been registered
				do_action('wesub_menu_registered');
			}

			// Add Welcome submenu (replaces the auto-generated one)
			add_submenu_page(
				'webeffortless', // Parent menu slug
				'WebEffortless - Welcome', // Page title
				'Welcome', // Menu title
				'manage_options', // Capability required
				'webeffortless', // Same slug as parent
				array($this, 'welcome_page_content') // Callback function
			);

			// Add Subscriptions submenu
			add_submenu_page(
				'webeffortless', // Parent menu slug
				'WE Subscription', // Page title
				'Subscriptions', // Menu title
				'manage_options', // Capability required
				'wesub-subscription', // Menu slug
				array($this, 'submenu_page_content') // Callback function
			);

			// Allow other plugins to register additional submenus
			do_action('wesub_register_submenus');
		}

		/**
		 * Callback function to display the welcome page content
		 */
		public function welcome_page_content()
		{
			include_once WESUB_PATH . 'templates/admin/we-welcome-page.php';
		}

		/**
		 * Callback function to display the submenu page content
		 */
		public function submenu_page_content()
		{
			include_once WESUB_PATH . 'templates/admin/we-subscription-setting-page.php';
		}

		/**
		 * Saved the settings
		 */
		public function wesub_handle_setting_form_submission()
		{

			check_ajax_referer('we-backend-nonce', 'nonce');

			// Get form data.
			$form_data_raw = isset($_POST['form_data']) ? wp_unslash($_POST['form_data']) : '';

			// Parse the string into an array first (handles decoding).
			$form_data = array();
			parse_str($form_data_raw, $form_data);

			// Sanitize the array values.
			$form_data = array_map('sanitize_text_field', $form_data);

			$add_to_cart_button_text = isset($form_data['we-add-to-cart-button-text']) ? $form_data['we-add-to-cart-button-text'] : null;
			$place_order_text = isset($form_data['we-place-order-text']) ? $form_data['we-place-order-text'] : null;
			$assign_user_role = isset($form_data['we-assign-user-role']) ? $form_data['we-assign-user-role'] : null;
			$remove_assign_user_role = isset($form_data['we-remove-assign-user-role']) ? $form_data['we-remove-assign-user-role'] : null;
			$manual_renewal_payment = isset($form_data['we-manual-renewal-payment']) ? $form_data['we-manual-renewal-payment'] : null;
			$retry_failed_renewals = isset($form_data['we-retry-failed-renewals']) ? $form_data['we-retry-failed-renewals'] : null;
			$multiple_product_purchases = isset($form_data['we-multiple-product-purchases']) ? $form_data['we-multiple-product-purchases'] : null;
			$user_can_cancel = isset($form_data['we-user-can-cancel']) ? $form_data['we-user-can-cancel'] : null;
			$is_logging = isset($form_data['wesub-log']) ? $form_data['wesub-log'] : null;

			update_option(
				'wesub_settings',
				array(
					'add_to_cart_button_text' => $add_to_cart_button_text,
					'place_order_text' => $place_order_text,
					'assign_user_role' => $assign_user_role,
					'remove_assign_user_role' => $remove_assign_user_role,
					'manual_payment' => $manual_renewal_payment,
					'retry_failed_renewals' => $retry_failed_renewals,
					'multiple_product_purchases' => $multiple_product_purchases,
					'user_can_cancel' => $user_can_cancel,
					'wesub_log' => $is_logging,
				)
			);
			echo wp_json_encode(array('success' => true));
			wp_die();
		}
	}
}
