/**
 * we-subscription-setting-page.js
 *
 * @package we-subscription
 * @version 1.0.0
 */
jQuery(function ($) {

    $(document).ready(function () {
        $('#we-settings-form').submit(function (e) {
            e.preventDefault(); // Prevent the default form submission

            // Serialize form data
            var formData = $(this).serialize();

            // AJAX request
            $.ajax({
                url: wesub_localize_object.ajaxurl, // WordPress AJAX handler URL
                type: 'POST',
                data: {
                    action: 'wesub_handle_setting_form_submission', // PHP function to handle the request
                    form_data: formData, // Send serialized form data
                    nonce: wesub_localize_object.nonce
                },
                success: function (response) {
                    // Handle success response
                    alert('Settings saved successfully');
                },
                error: function (xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                }
            });
        });

        // Open Modal
        $(document).on('click', '.wesub-view-renewals', function () {
            var id = $(this).data('id');
            var content = $('#wesub-renewals-content-' + id).html();
            $('#wesub-modal-body').html(content);
            $('#wesub-renewals-modal').show();
        });

        // Close Modal
        $('.wesub-close').on('click', function () {
            $('#wesub-renewals-modal').hide();
        });

        // Close on outside click
        $(window).on('click', function (event) {
            if (event.target.id == 'wesub-renewals-modal') {
                $('#wesub-renewals-modal').hide();
            }
        });
    });
});