/**
 * we-subscription-product-edit-page.js
 *
 * @package we-subscription
 * @version 1.0.0
 */
jQuery(function ($) {

    $(document).ready(function () {

        // simple product handling
        $(document).on( 'click', '#_wes_simple_subscription', function(){
            wesub_manage_the_subscription_setting_section();
        });

        function wesub_manage_the_subscription_setting_section() {
            if ( $( '#_wes_simple_subscription' ).is(":checked") ) {
                $('.wesub-product-settings-wrapper').show();
            } else {
                $('.wesub-product-settings-wrapper').hide();
            }
        }
        wesub_manage_the_subscription_setting_section();
        
        $(document).on( 'change', '.wesub-recurring-type', function(){
            const type = $(this).val();

            var interval_type = null;
            if ( 'day' == type ) {
                interval_type = wesub_product_edit_object.day;
            } else if ( 'week' == type ) {
                interval_type = wesub_product_edit_object.week;
            } else if ( 'month' == type ) {
                interval_type = wesub_product_edit_object.month;
            } else if ( 'year' == type ) {
                interval_type = wesub_product_edit_object.year;
            }
            $( '.wesub-expiration-type' ).val( interval_type );
        })

        // variable product handling

        $('#variable_product_options').on('change', '.wesub-variation-subscription', function(){
            $( this ).closest( '.woocommerce_variation' ).find( '.wesub-var-product-settings-wrapper' ).hide();
    
            if ( $( this ).is( ':checked' ) ) {
                $( this ).closest( '.woocommerce_variation' ).find( '.wesub-var-product-settings-wrapper' ).show();
            }
        });

        $( '#woocommerce-product-data' ).on( 'woocommerce_variations_loaded', function(event, needsUpdate) {
			needsUpdate = needsUpdate || false;
			var wrapper = $( '#woocommerce-product-data' );
			if ( ! needsUpdate ) {
				$( 'input.wesub-variation-subscription', wrapper ).trigger( 'change' );
			}
		});

        $('#variable_product_options').on('change', '.wesub-var-recurring-type', function(){
            const type = $(this).val();

            var interval_type = null;
            if ( 'day' == type ) {
                interval_type = wesub_product_edit_object.day;
            } else if ( 'week' == type ) {
                interval_type = wesub_product_edit_object.week;
            } else if ( 'month' == type ) {
                interval_type = wesub_product_edit_object.month;
            } else if ( 'year' == type ) {
                interval_type = wesub_product_edit_object.year;
            }
            $( this ).closest( '.woocommerce_variation' ).find( '.wesub-var-expiration-type' ).val(interval_type);
        });
    });
});