# WE Subscription

[![WordPress Plugin Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](https://github.com/webeffortless/we-subscription)
[![WordPress](https://img.shields.io/badge/WordPress-5.5%2B-blue.svg)](https://wordpress.org/)
[![WooCommerce](https://img.shields.io/badge/WooCommerce-5.5.0%2B-purple.svg)](https://woocommerce.com/)
[![PHP](https://img.shields.io/badge/PHP-7.4%2B-purple.svg)](https://php.net/)
[![License](https://img.shields.io/badge/license-GPL--3.0-green.svg)](LICENSE.txt)

A **lightweight and performance-optimized** WooCommerce subscription plugin that enables recurring payments without the bloat. Built with efficiency in mind, ensuring fast page loads and minimal database queries.

## 🚀 Why Choose WE Subscription?

- **Lightweight Code:** Minimal footprint with clean, optimized code
- **Fast Performance:** No unnecessary features slowing down your site
- **Database Optimized:** Efficient queries and proper indexing
- **No Bloat:** Only essential features you actually need
- **HPOS Compatible:** Full support for WooCommerce High-Performance Order Storage

## ✨ Features

### Core Functionality
- **Simple & Variable Subscriptions:** Convert any simple or variable product into a subscription
- **Flexible Billing Schedules:** Set daily, weekly, monthly, or yearly billing intervals
- **Subscription Management:** Admin interface to view and manage subscriptions (cancel, delete)
- **Customer Portal:** Customers can view their active subscriptions and renewal history from their My Account page
- **Email Notifications:** Automated emails for subscription renewal, cancellation, and expiration
- **User Role Management:** Manage user roles based on subscription activity

### Payment Gateway Integration
- **Stripe Integration:** Built-in compatibility with WooCommerce Stripe Gateway plugin
  - Credit/Debit card payments
  - SEPA debit method
  - Automatic renewals
  - Change payment method functionality
- **Manual Renewals:** Support for manual renewal payments

### Technical Features
- **HPOS Compatible:** Full support for WooCommerce High-Performance Order Storage
- **WooCommerce Blocks:** Compatible with WooCommerce Cart & Checkout Blocks
- **Custom Order Tables:** Declares compatibility with WooCommerce custom order tables
- **Minimal Database Footprint:** Optimized database queries and efficient data storage

## 📋 Requirements

- **WordPress:** 5.5 or higher
- **WooCommerce:** 5.5.0 or higher
- **PHP:** 7.4 or higher
- **WooCommerce Stripe Payment Gateway** (for automatic recurring payments)

## 📦 Installation

### From WordPress Admin

1. Visit **Plugins > Add New**
2. Search for **We Subscription**
3. Install and activate the plugin

### Manual Installation

1. Download the plugin files
2. Upload the entire `we-subscription` folder to `/wp-content/plugins/`
3. Visit **Plugins** in WordPress admin
4. Activate the **WE Subscription** plugin

### Via Composer

```bash
composer require webeffortless/we-subscription
```

## 🔧 Configuration

### Setting Up Subscriptions

1. Navigate to **WooCommerce > Settings > Subscriptions**
2. Configure general subscription settings
3. Set up email notifications
4. Configure user role management options

### Creating Subscription Products

#### Simple Products
1. Edit or create a new product
2. In the **Product Data** panel, select **Simple Subscription**
3. Set the subscription price and billing interval
4. Publish the product

#### Variable Products
1. Edit or create a new variable product
2. For each variation, configure subscription settings
3. Set individual pricing and billing intervals per variation
4. Save the product

### Payment Gateway Setup

1. Install and activate **WooCommerce Stripe Payment Gateway**
2. Configure your Stripe API keys
3. Enable the payment methods you want to support (Card, SEPA)
4. Subscriptions will automatically use Stripe for recurring payments

## 📁 Project Structure

```
we-subscription/
├── assets/              # Plugin assets (CSS, JS, images)
├── emails/              # Email templates
├── gateways/            # Payment gateway integrations
│   └── woocommerce-gateway-stripe/
├── includes/            # Core plugin files
│   ├── admin/          # Admin-specific functionality
│   ├── class-we-subscription.php
│   ├── class-wesub-autoloader.php
│   ├── class-wesub-handle-pricing.php
│   ├── class-wesub-log.php
│   ├── functions-wesub-common.php
│   ├── wesub-handle-subscription.php
│   ├── wesub-order-type.php
│   └── wesub-scheduled-actions.php
├── languages/           # Translation files
├── templates/           # Frontend templates
├── wc-block/           # WooCommerce Blocks integration
├── LICENSE.txt
├── README.md
├── readme.txt          # WordPress.org readme
├── uninstall.php
└── we-subscription.php # Main plugin file
```

## 🎨 Usage

### For Customers

#### Viewing Subscriptions
1. Log in to your account
2. Navigate to **My Account > Subscriptions**
3. View all active and past subscriptions

#### Managing Subscriptions
- **Cancel:** Cancel an active subscription from the subscription details page
- **Change Payment Method:** Update payment method for automatic renewals (Stripe only)
- **View Renewal History:** See all past renewal orders

### For Administrators

#### Managing Subscriptions
1. Navigate to **WooCommerce > Subscriptions**
2. View all customer subscriptions
3. Perform actions: Cancel, Delete, or view details

#### Monitoring
- View subscription status
- Track renewal dates
- Monitor payment failures
- Review subscription-related orders

## 🔌 Hooks & Filters

### Actions

```php
// Fired when a subscription is created
do_action('wesub_subscription_created', $wesub_subscription_id);

// Fired when a subscription is renewed
do_action('wesub_subscription_renewed', $wesub_subscription_id, $order_id);

// Fired when a subscription is cancelled
do_action('wesub_subscription_cancelled', $wesub_subscription_id);
```

### Filters

```php
// Modify subscription intervals
apply_filters('wesub_subscription_intervals', $intervals);

// Modify subscription price display
apply_filters('wesub_subscription_price_string', $price_string, $wesub_subscription);
```

## 🛠️ Development

### Setting Up Development Environment

```bash
# Clone the repository
git clone https://github.com/webeffortless/we-subscription.git

# Navigate to plugin directory
cd we-subscription

# Install dependencies (if any)
composer install
```

### Coding Standards

This plugin follows [WordPress Coding Standards](https://developer.wordpress.org/coding-standards/wordpress-coding-standards/).

- Text Domain: `we-subscription`
- Prefix: `wesub_` for functions, `WESUB_` for classes

## 📧 Email Templates

The plugin includes the following email templates:

- **Subscription Created:** Sent when a new subscription is created
- **Subscription Renewal:** Sent when a subscription is successfully renewed
- **Subscription Cancelled:** Sent when a subscription is cancelled
- **Subscription Expired:** Sent when a subscription expires
- **Payment Failed:** Sent when a renewal payment fails

Email templates can be customized by copying them to your theme:
```
your-theme/woocommerce/emails/
```

## 🤝 Support

- **Documentation:** [http://webeffortless.com/docs/we-subscription/](http://webeffortless.com/docs/we-subscription/)
- **Support:** [http://webeffortless.com/support](http://webeffortless.com/support)
- **Issues:** Report bugs via our support portal

## 📝 Changelog

### 1.0.0 - Initial Release
- Simple and variable product subscriptions
- Stripe payment gateway integration (card and SEPA debit)
- Flexible billing schedules (daily, weekly, monthly, yearly)
- Customer subscription management portal
- Admin subscription management interface
- Automated email notifications
- Change payment method functionality
- Manual renewal payment option
- HPOS (High-Performance Order Storage) compatible
- Minimal database footprint

## 📄 License

This plugin is licensed under the GNU General Public License v3.0 or later.

See [LICENSE.txt](LICENSE.txt) for more information.

## 👥 Credits

**WE Subscription** is developed and maintained by [WebEffortless](http://webeffortless.com/).

## 🌟 Contributing

We welcome contributions! Please feel free to submit pull requests or open issues for bugs and feature requests.

---

Made with ❤️ by [WebEffortless](http://webeffortless.com/)
