<?php
/**
 * Plugin Name: WD Translator
 * Plugin URI: https://wolfdevs.com/products/wd-translator
 * Description: Website translation with Google Translate and OpenAI GPT support
 * Version: 1.0.0
 * Author: WolfDevs
 * Author URI: https://wolfdevs.com
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wd-translator
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

if (!defined('ABSPATH')) {
    exit;
}

define('WD_TRANSLATOR_VERSION', '1.0.0');
define('WD_TRANSLATOR_PLUGIN_FILE', __FILE__);
define('WD_TRANSLATOR_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WD_TRANSLATOR_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WD_TRANSLATOR_PLUGIN_BASENAME', plugin_basename(__FILE__));

require_once WD_TRANSLATOR_PLUGIN_DIR . 'vendor/autoload.php';

register_activation_hook(__FILE__, ['WD_TRANSLATOR\\Activator', 'activate']);
register_deactivation_hook(__FILE__, ['WD_TRANSLATOR\\Deactivator', 'deactivate']);

add_action('plugins_loaded', function() {
    WD_TRANSLATOR\Plugin::instance()->init();
});
