<?php

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

$wd_translator_table_name = $wpdb->prefix . 'wd_translator_translations';
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter -- Uninstall cleanup, table name safely constructed from $wpdb->prefix
$wpdb->query("DROP TABLE IF EXISTS {$wd_translator_table_name}");

$wd_translator_options = [
    'wd_translator_db_version',
    'wd_translator_enabled',
    'wd_translator_translation_provider',
    'wd_translator_google_api_key',
    'wd_translator_openai_api_key',
    'wd_translator_openai_model',
    'wd_translator_source_language',
    'wd_translator_enabled_languages',
    'wd_translator_widget_style',
    'wd_translator_widget_position',
    'wd_translator_bg_color',
    'wd_translator_text_color',
    'wd_translator_border_color',
    'wd_translator_hover_bg_color',
    'wd_translator_active_bg_color',
    'wd_translator_border_radius',
    'wd_translator_shadow',
    'wd_translator_font_size',
    'wd_translator_show_flags',
    'wd_translator_language_display',
    'wd_translator_cache_enabled',
    'wd_translator_cache_ttl',
    'wd_translator_custom_css',
    'wd_translator_language_customizations',
];

foreach ($wd_translator_options as $wd_translator_option) {
    delete_option($wd_translator_option);
}
