<?php

namespace WD_TRANSLATOR\Utilities;

class LanguageList {

    private static array $languages = [
        'af' => ['name' => 'Afrikaans', 'native' => 'Afrikaans', 'rtl' => false],
        'sq' => ['name' => 'Albanian', 'native' => 'Shqip', 'rtl' => false],
        'am' => ['name' => 'Amharic', 'native' => 'አማርኛ', 'rtl' => false],
        'ar' => ['name' => 'Arabic', 'native' => 'العربية', 'rtl' => true],
        'hy' => ['name' => 'Armenian', 'native' => 'Հայերdelays', 'rtl' => false],
        'az' => ['name' => 'Azerbaijani', 'native' => 'Azərbaycan', 'rtl' => false],
        'eu' => ['name' => 'Basque', 'native' => 'Euskara', 'rtl' => false],
        'be' => ['name' => 'Belarusian', 'native' => 'Беларуская', 'rtl' => false],
        'bn' => ['name' => 'Bengali', 'native' => 'বাংলা', 'rtl' => false],
        'bs' => ['name' => 'Bosnian', 'native' => 'Bosanski', 'rtl' => false],
        'bg' => ['name' => 'Bulgarian', 'native' => 'Български', 'rtl' => false],
        'my' => ['name' => 'Burmese', 'native' => 'မြန်မာ', 'rtl' => false],
        'ca' => ['name' => 'Catalan', 'native' => 'Català', 'rtl' => false],
        'zh' => ['name' => 'Chinese', 'native' => '中文', 'rtl' => false],
        'zh-CN' => ['name' => 'Chinese (Simplified)', 'native' => '简体中文', 'rtl' => false],
        'zh-TW' => ['name' => 'Chinese (Traditional)', 'native' => '繁體中文', 'rtl' => false],
        'hr' => ['name' => 'Croatian', 'native' => 'Hrvatski', 'rtl' => false],
        'cs' => ['name' => 'Czech', 'native' => 'Čeština', 'rtl' => false],
        'da' => ['name' => 'Danish', 'native' => 'Dansk', 'rtl' => false],
        'nl' => ['name' => 'Dutch', 'native' => 'Nederlands', 'rtl' => false],
        'en' => ['name' => 'English', 'native' => 'English', 'rtl' => false],
        'et' => ['name' => 'Estonian', 'native' => 'Eesti', 'rtl' => false],
        'fi' => ['name' => 'Finnish', 'native' => 'Suomi', 'rtl' => false],
        'fr' => ['name' => 'French', 'native' => 'Français', 'rtl' => false],
        'gl' => ['name' => 'Galician', 'native' => 'Galego', 'rtl' => false],
        'ka' => ['name' => 'Georgian', 'native' => 'ქართული', 'rtl' => false],
        'de' => ['name' => 'German', 'native' => 'Deutsch', 'rtl' => false],
        'el' => ['name' => 'Greek', 'native' => 'Ελληνικά', 'rtl' => false],
        'gu' => ['name' => 'Gujarati', 'native' => 'ગુજરાતી', 'rtl' => false],
        'ht' => ['name' => 'Haitian Creole', 'native' => 'Kreyòl Ayisyen', 'rtl' => false],
        'ha' => ['name' => 'Hausa', 'native' => 'Hausa', 'rtl' => false],
        'he' => ['name' => 'Hebrew', 'native' => 'עברית', 'rtl' => true],
        'hi' => ['name' => 'Hindi', 'native' => 'हिन्दी', 'rtl' => false],
        'hu' => ['name' => 'Hungarian', 'native' => 'Magyar', 'rtl' => false],
        'is' => ['name' => 'Icelandic', 'native' => 'Íslenska', 'rtl' => false],
        'ig' => ['name' => 'Igbo', 'native' => 'Igbo', 'rtl' => false],
        'id' => ['name' => 'Indonesian', 'native' => 'Bahasa Indonesia', 'rtl' => false],
        'ga' => ['name' => 'Irish', 'native' => 'Gaeilge', 'rtl' => false],
        'it' => ['name' => 'Italian', 'native' => 'Italiano', 'rtl' => false],
        'ja' => ['name' => 'Japanese', 'native' => '日本語', 'rtl' => false],
        'jv' => ['name' => 'Javanese', 'native' => 'Basa Jawa', 'rtl' => false],
        'kn' => ['name' => 'Kannada', 'native' => 'ಕನ್ನಡ', 'rtl' => false],
        'kk' => ['name' => 'Kazakh', 'native' => 'Қазақ', 'rtl' => false],
        'km' => ['name' => 'Khmer', 'native' => 'ខ្មែរ', 'rtl' => false],
        'rw' => ['name' => 'Kinyarwanda', 'native' => 'Ikinyarwanda', 'rtl' => false],
        'ko' => ['name' => 'Korean', 'native' => '한국어', 'rtl' => false],
        'ku' => ['name' => 'Kurdish', 'native' => 'Kurdî', 'rtl' => false],
        'ky' => ['name' => 'Kyrgyz', 'native' => 'Кыргызча', 'rtl' => false],
        'lo' => ['name' => 'Lao', 'native' => 'ລາວ', 'rtl' => false],
        'lv' => ['name' => 'Latvian', 'native' => 'Latviešu', 'rtl' => false],
        'lt' => ['name' => 'Lithuanian', 'native' => 'Lietuvių', 'rtl' => false],
        'lb' => ['name' => 'Luxembourgish', 'native' => 'Lëtzebuergesch', 'rtl' => false],
        'mk' => ['name' => 'Macedonian', 'native' => 'Македонски', 'rtl' => false],
        'mg' => ['name' => 'Malagasy', 'native' => 'Malagasy', 'rtl' => false],
        'ms' => ['name' => 'Malay', 'native' => 'Bahasa Melayu', 'rtl' => false],
        'ml' => ['name' => 'Malayalam', 'native' => 'മലയാളം', 'rtl' => false],
        'mt' => ['name' => 'Maltese', 'native' => 'Malti', 'rtl' => false],
        'mi' => ['name' => 'Maori', 'native' => 'Māori', 'rtl' => false],
        'mr' => ['name' => 'Marathi', 'native' => 'मराठी', 'rtl' => false],
        'mn' => ['name' => 'Mongolian', 'native' => 'Монгол', 'rtl' => false],
        'ne' => ['name' => 'Nepali', 'native' => 'नेपाली', 'rtl' => false],
        'no' => ['name' => 'Norwegian', 'native' => 'Norsk', 'rtl' => false],
        'ny' => ['name' => 'Nyanja', 'native' => 'Chichewa', 'rtl' => false],
        'or' => ['name' => 'Odia', 'native' => 'ଓଡ଼ିଆ', 'rtl' => false],
        'ps' => ['name' => 'Pashto', 'native' => 'پښتو', 'rtl' => true],
        'fa' => ['name' => 'Persian', 'native' => 'فارسی', 'rtl' => true],
        'pl' => ['name' => 'Polish', 'native' => 'Polski', 'rtl' => false],
        'pt' => ['name' => 'Portuguese', 'native' => 'Português', 'rtl' => false],
        'pt-BR' => ['name' => 'Portuguese (Brazil)', 'native' => 'Português (Brasil)', 'rtl' => false],
        'pa' => ['name' => 'Punjabi', 'native' => 'ਪੰਜਾਬੀ', 'rtl' => false],
        'ro' => ['name' => 'Romanian', 'native' => 'Română', 'rtl' => false],
        'ru' => ['name' => 'Russian', 'native' => 'Русский', 'rtl' => false],
        'sm' => ['name' => 'Samoan', 'native' => 'Gagana Samoa', 'rtl' => false],
        'gd' => ['name' => 'Scottish Gaelic', 'native' => 'Gàidhlig', 'rtl' => false],
        'sr' => ['name' => 'Serbian', 'native' => 'Српски', 'rtl' => false],
        'st' => ['name' => 'Sesotho', 'native' => 'Sesotho', 'rtl' => false],
        'sn' => ['name' => 'Shona', 'native' => 'ChiShona', 'rtl' => false],
        'sd' => ['name' => 'Sindhi', 'native' => 'سنڌي', 'rtl' => true],
        'si' => ['name' => 'Sinhala', 'native' => 'සිංහල', 'rtl' => false],
        'sk' => ['name' => 'Slovak', 'native' => 'Slovenčina', 'rtl' => false],
        'sl' => ['name' => 'Slovenian', 'native' => 'Slovenščina', 'rtl' => false],
        'so' => ['name' => 'Somali', 'native' => 'Soomaali', 'rtl' => false],
        'es' => ['name' => 'Spanish', 'native' => 'Español', 'rtl' => false],
        'su' => ['name' => 'Sundanese', 'native' => 'Basa Sunda', 'rtl' => false],
        'sw' => ['name' => 'Swahili', 'native' => 'Kiswahili', 'rtl' => false],
        'sv' => ['name' => 'Swedish', 'native' => 'Svenska', 'rtl' => false],
        'tl' => ['name' => 'Tagalog', 'native' => 'Tagalog', 'rtl' => false],
        'tg' => ['name' => 'Tajik', 'native' => 'Тоҷикӣ', 'rtl' => false],
        'ta' => ['name' => 'Tamil', 'native' => 'தமிழ்', 'rtl' => false],
        'tt' => ['name' => 'Tatar', 'native' => 'Татар', 'rtl' => false],
        'te' => ['name' => 'Telugu', 'native' => 'తెలుగు', 'rtl' => false],
        'th' => ['name' => 'Thai', 'native' => 'ไทย', 'rtl' => false],
        'tr' => ['name' => 'Turkish', 'native' => 'Türkçe', 'rtl' => false],
        'tk' => ['name' => 'Turkmen', 'native' => 'Türkmen', 'rtl' => false],
        'uk' => ['name' => 'Ukrainian', 'native' => 'Українська', 'rtl' => false],
        'ur' => ['name' => 'Urdu', 'native' => 'اردو', 'rtl' => true],
        'ug' => ['name' => 'Uyghur', 'native' => 'ئۇيغۇرچە', 'rtl' => true],
        'uz' => ['name' => 'Uzbek', 'native' => 'Oʻzbek', 'rtl' => false],
        'vi' => ['name' => 'Vietnamese', 'native' => 'Tiếng Việt', 'rtl' => false],
        'cy' => ['name' => 'Welsh', 'native' => 'Cymraeg', 'rtl' => false],
        'xh' => ['name' => 'Xhosa', 'native' => 'isiXhosa', 'rtl' => false],
        'yi' => ['name' => 'Yiddish', 'native' => 'ייִדיש', 'rtl' => true],
        'yo' => ['name' => 'Yoruba', 'native' => 'Yorùbá', 'rtl' => false],
        'zu' => ['name' => 'Zulu', 'native' => 'isiZulu', 'rtl' => false],
    ];

    public static function get_all(): array {
        return self::$languages;
    }

    public static function get(string $code): ?array {
        return self::$languages[$code] ?? null;
    }

    public static function get_language_name(string $code, string $format = 'name'): string {
        $lang = self::get($code);
        if (!$lang) {
            return $code;
        }
        return $lang[$format] ?? $lang['name'];
    }

    public static function get_enabled_languages(): array {
        $enabled_codes = get_option('wd_translator_enabled_languages', []);
        if (!is_array($enabled_codes)) {
            $enabled_codes = [];
        }

        $source_lang = get_option('wd_translator_source_language', 'en');
        $languages = [];

        if (isset(self::$languages[$source_lang])) {
            $languages[$source_lang] = self::$languages[$source_lang];
        }

        foreach ($enabled_codes as $code) {
            if (isset(self::$languages[$code]) && $code !== $source_lang) {
                $languages[$code] = self::$languages[$code];
            }
        }

        return $languages;
    }

    public static function is_rtl(string $code): bool {
        $lang = self::get($code);
        return $lang['rtl'] ?? false;
    }

    public static function get_codes(): array {
        return array_keys(self::$languages);
    }

    public static function search(string $query): array {
        $query = strtolower($query);
        $results = [];

        foreach (self::$languages as $code => $lang) {
            if (
                strpos(strtolower($code), $query) !== false ||
                strpos(strtolower($lang['name']), $query) !== false ||
                strpos(strtolower($lang['native']), $query) !== false
            ) {
                $results[$code] = $lang;
            }
        }

        return $results;
    }

    public static function get_enabled_languages_with_customizations(): array {
        $enabled_codes = get_option('wd_translator_enabled_languages', []);
        if (!is_array($enabled_codes)) {
            $enabled_codes = [];
        }
        $customizations = get_option('wd_translator_language_customizations', []);
        if (!is_array($customizations)) {
            $customizations = [];
        }
        $source_lang = get_option('wd_translator_source_language', 'en');

        $languages = [];

        if (isset(self::$languages[$source_lang])) {
            $lang = self::$languages[$source_lang];
            $custom = $customizations[$source_lang] ?? [];
            $languages[$source_lang] = self::merge_customization($lang, $custom);
        }

        foreach ($enabled_codes as $code) {
            if (isset(self::$languages[$code]) && $code !== $source_lang) {
                $lang = self::$languages[$code];
                $custom = $customizations[$code] ?? [];
                $languages[$code] = self::merge_customization($lang, $custom);
            }
        }

        return $languages;
    }

    private static function merge_customization(array $lang, array $custom): array {
        return array_merge($lang, [
            'custom_label' => $custom['custom_label'] ?? '',
            'custom_flag_url' => $custom['custom_flag_url'] ?? '',
            'custom_flag_id' => $custom['custom_flag_id'] ?? 0,
        ]);
    }
}
