<?php

namespace WD_TRANSLATOR;

if (!defined('ABSPATH')) {
    exit;
}

class Plugin {

    private static ?Plugin $instance = null;
    private Loader $loader;

    public static function instance(): Plugin {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->loader = new Loader();
    }

    public function init(): void {
        $this->register_admin_hooks();
        $this->register_public_hooks();
        $this->register_rest_hooks();
        $this->loader->run();
    }

    private function register_admin_hooks(): void {
        if (!is_admin()) {
            return;
        }

        $admin = new Admin\Admin();
        $this->loader->add_action('admin_menu', $admin, 'add_menu');
        $this->loader->add_action('admin_init', $admin, 'register_settings');
        $this->loader->add_action('admin_enqueue_scripts', $admin, 'enqueue_assets');
        $this->loader->add_action('admin_head', $admin, 'enqueue_menu_icon_styles');
    }

    private function register_public_hooks(): void {
        $public = new Frontend\Frontend();
        $this->loader->add_action('wp_enqueue_scripts', $public, 'enqueue_assets');
        $this->loader->add_action('wp_footer', $public, 'render_widget');
        $this->loader->add_action('init', $public, 'register_shortcodes');
    }

    private function register_rest_hooks(): void {
        add_action('rest_api_init', [Api\RestController::class, 'init']);
    }

    public function get_translator(): Translation\Translator {
        static $translator = null;
        if (null === $translator) {
            $translator = new Translation\Translator($this->get_cache_manager());
        }
        return $translator;
    }

    public function get_cache_manager(): Cache\CacheManager {
        static $cache = null;
        if (null === $cache) {
            $cache = new Cache\CacheManager();
        }
        return $cache;
    }
}
