<?php

namespace WD_TRANSLATOR;

if (!defined('ABSPATH')) {
    exit;
}

class Loader {

    private array $actions = [];
    private array $filters = [];

    public function add_action(string $hook, $component, string $callback, int $priority = 10, int $args = 1): void {
        $this->actions[] = [
            'hook' => $hook,
            'component' => $component,
            'callback' => $callback,
            'priority' => $priority,
            'args' => $args,
        ];
    }

    public function add_filter(string $hook, $component, string $callback, int $priority = 10, int $args = 1): void {
        $this->filters[] = [
            'hook' => $hook,
            'component' => $component,
            'callback' => $callback,
            'priority' => $priority,
            'args' => $args,
        ];
    }

    public function run(): void {
        foreach ($this->filters as $hook) {
            add_filter(
                $hook['hook'],
                [$hook['component'], $hook['callback']],
                $hook['priority'],
                $hook['args']
            );
        }

        foreach ($this->actions as $hook) {
            add_action(
                $hook['hook'],
                [$hook['component'], $hook['callback']],
                $hook['priority'],
                $hook['args']
            );
        }
    }
}
