<?php

namespace WD_TRANSLATOR\Admin;

if (!defined('ABSPATH')) {
    exit;
}

use WD_TRANSLATOR\Utilities\LanguageList;

class Admin {

    public function add_menu(): void {
        add_menu_page(
            __('WD Translator', 'wd-translator'),
            __('WD Translator', 'wd-translator'),
            'manage_options',
            'wd-translator',
            [$this, 'render_settings_page'],
            WD_TRANSLATOR_PLUGIN_URL . 'public/images/wd-translator-logo-monochrome.svg',
            30
        );
    }

    public function enqueue_menu_icon_styles(): void {
        wp_add_inline_style('admin-menu', '#adminmenu .toplevel_page_wd-translator .wp-menu-image img{width:20px;height:20px;padding:7px 0 0;opacity:1}');
    }

    public function register_settings(): void {
        register_setting('wd_translator_settings', 'wd_translator_enabled', [
            'type' => 'boolean',
            'sanitize_callback' => 'rest_sanitize_boolean',
            'default' => false,
        ]);
        register_setting('wd_translator_settings', 'wd_translator_translation_provider', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => 'google',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_google_api_key', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => '',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_openai_api_key', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => '',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_openai_model', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => 'gpt-4o',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_source_language', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => 'en',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_enabled_languages', [
            'type' => 'array',
            'sanitize_callback' => [$this, 'sanitize_language_array'],
            'default' => [],
        ]);
        register_setting('wd_translator_settings', 'wd_translator_widget_style', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => 'dropdown',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_widget_position', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => 'bottom-right',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_bg_color', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_hex_color',
            'default' => '#ffffff',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_text_color', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_hex_color',
            'default' => '#1f2937',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_border_color', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_hex_color',
            'default' => '#e5e7eb',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_hover_bg_color', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_hex_color',
            'default' => '#f3f4f6',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_active_bg_color', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_hex_color',
            'default' => '#e0f2fe',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_border_radius', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => '8',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_shadow', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => 'medium',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_font_size', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => '14',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_show_flags', [
            'type' => 'boolean',
            'sanitize_callback' => 'rest_sanitize_boolean',
            'default' => true,
        ]);
        register_setting('wd_translator_settings', 'wd_translator_language_display', [
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => 'native',
        ]);
        register_setting('wd_translator_settings', 'wd_translator_cache_enabled', [
            'type' => 'boolean',
            'sanitize_callback' => 'rest_sanitize_boolean',
            'default' => true,
        ]);
        register_setting('wd_translator_settings', 'wd_translator_cache_ttl', [
            'type' => 'integer',
            'sanitize_callback' => 'absint',
            'default' => 86400,
        ]);
        register_setting('wd_translator_settings', 'wd_translator_language_customizations', [
            'type' => 'array',
            'sanitize_callback' => [$this, 'sanitize_language_customizations'],
            'default' => [],
        ]);
    }

    public function sanitize_language_array($value): array {
        if (!is_array($value)) {
            return [];
        }
        return array_map('sanitize_text_field', $value);
    }

    public function sanitize_language_customizations($value): array {
        if (!is_array($value)) {
            return [];
        }
        $sanitized = [];
        foreach ($value as $code => $data) {
            $sanitized_code = sanitize_text_field($code);
            $sanitized[$sanitized_code] = [
                'custom_label' => isset($data['custom_label']) ? sanitize_text_field($data['custom_label']) : '',
                'custom_flag_url' => isset($data['custom_flag_url']) ? esc_url_raw($data['custom_flag_url']) : '',
                'custom_flag_id' => isset($data['custom_flag_id']) ? absint($data['custom_flag_id']) : 0,
            ];
        }
        return $sanitized;
    }

    public function enqueue_assets(string $hook): void {
        if ($hook !== 'toplevel_page_wd-translator') {
            return;
        }

        wp_enqueue_media();
        wp_enqueue_style('wp-color-picker');

        wp_enqueue_style(
            'wd-translator-flags',
            WD_TRANSLATOR_PLUGIN_URL . 'public/css/flags.css',
            [],
            WD_TRANSLATOR_VERSION
        );

        wp_enqueue_style(
            'wd-translator-admin',
            WD_TRANSLATOR_PLUGIN_URL . 'admin/css/admin.css',
            ['wd-translator-flags'],
            WD_TRANSLATOR_VERSION
        );

        wp_enqueue_script(
            'wd-translator-admin',
            WD_TRANSLATOR_PLUGIN_URL . 'admin/js/admin.js',
            ['jquery', 'wp-color-picker'],
            WD_TRANSLATOR_VERSION,
            true
        );

        wp_localize_script('wd-translator-admin', 'wdTranslatorAdmin', [
            'restUrl' => rest_url('wd-translator/v1/'),
            'nonce' => wp_create_nonce('wp_rest'),
            'languages' => LanguageList::get_all(),
            'strings' => [
                'verifying' => __('Verifying...', 'wd-translator'),
                'valid' => __('API key is valid', 'wd-translator'),
                'invalid' => __('API key is invalid', 'wd-translator'),
                'clearing' => __('Clearing cache...', 'wd-translator'),
                'cleared' => __('Cache cleared', 'wd-translator'),
                'saving' => __('Saving...', 'wd-translator'),
                'saved' => __('Settings saved', 'wd-translator'),
                'error' => __('An error occurred', 'wd-translator'),
                'customizeTitle' => __('Customize', 'wd-translator'),
                'selectFlagImage' => __('Select Flag Image', 'wd-translator'),
                'useThisImage' => __('Use this image', 'wd-translator'),
            ],
        ]);
    }

    public function render_settings_page(): void {
        if (!current_user_can('manage_options')) {
            return;
        }

        include WD_TRANSLATOR_PLUGIN_DIR . 'admin/partials/settings-page.php';
    }
}
