<?php

namespace WD_TRANSLATOR;

class Activator {

    public static function activate(): void {
        self::create_tables();
        self::set_default_options();
        flush_rewrite_rules();
    }

    private static function create_tables(): void {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . 'wd_translator_translations';

        $sql = "CREATE TABLE {$table_name} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            content_hash VARCHAR(64) NOT NULL,
            source_lang VARCHAR(10) NOT NULL DEFAULT 'en',
            target_lang VARCHAR(10) NOT NULL,
            original_text LONGTEXT NOT NULL,
            translated_text LONGTEXT NOT NULL,
            word_count INT(11) UNSIGNED DEFAULT 0,
            api_tokens_used INT(11) UNSIGNED DEFAULT 0,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            expires_at DATETIME DEFAULT NULL,
            hit_count BIGINT(20) UNSIGNED DEFAULT 0,
            PRIMARY KEY (id),
            UNIQUE KEY content_hash_langs (content_hash, source_lang, target_lang),
            KEY target_lang (target_lang),
            KEY expires_at (expires_at),
            KEY created_at (created_at)
        ) {$charset_collate};";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);

        update_option('wd_translator_db_version', WD_TRANSLATOR_VERSION);
    }

    private static function set_default_options(): void {
        $defaults = [
            'wd_translator_enabled' => true,
            'wd_translator_translation_provider' => 'google',
            'wd_translator_google_api_key' => '',
            'wd_translator_openai_api_key' => '',
            'wd_translator_openai_model' => 'gpt-5.2',
            'wd_translator_source_language' => 'en',
            'wd_translator_enabled_languages' => ['es', 'fr', 'de', 'it', 'pt', 'zh', 'ja', 'ko', 'ar', 'ru'],
            'wd_translator_widget_style' => 'floating',
            'wd_translator_widget_position' => 'bottom-right',
            'wd_translator_bg_color' => '#ffffff',
            'wd_translator_text_color' => '#374151',
            'wd_translator_border_color' => '#e5e7eb',
            'wd_translator_hover_bg_color' => '#f9fafb',
            'wd_translator_active_bg_color' => '#f3f4f6',
            'wd_translator_border_radius' => 'medium',
            'wd_translator_shadow' => 'subtle',
            'wd_translator_font_size' => 'medium',
            'wd_translator_show_flags' => true,
            'wd_translator_language_display' => 'native',
            'wd_translator_cache_enabled' => true,
            'wd_translator_cache_ttl' => 7,
            'wd_translator_custom_css' => '',
        ];

        foreach ($defaults as $key => $value) {
            if (get_option($key) === false) {
                update_option($key, $value);
            }
        }
    }
}
