<?php
if (!defined('ABSPATH')) {
    exit;
}

$wd_translator_languages = \WD_TRANSLATOR\Utilities\LanguageList::get_all();
$wd_translator_enabled_languages = get_option('wd_translator_enabled_languages', []);
if (!is_array($wd_translator_enabled_languages)) {
    $wd_translator_enabled_languages = [];
}
$wd_translator_current_provider = get_option('wd_translator_translation_provider', 'google');
?>

<div class="wd-translator-settings-container">
    <div class="wd-translator-settings-header">
        <img src="<?php echo esc_url(WD_TRANSLATOR_PLUGIN_URL . 'public/images/wd-translator-logo.svg'); ?>" alt="<?php esc_attr_e('WD Translator', 'wd-translator'); ?>" class="wd-translator-logo">
        <div class="wd-translator-header-text">
            <h1><?php esc_html_e('WD Translator', 'wd-translator'); ?></h1>
            <p><?php esc_html_e('Configure your website translation settings', 'wd-translator'); ?></p>
        </div>
    </div>

    <div class="wd-translator-tabs">
        <button type="button" class="wd-translator-tab active" data-tab="general"><?php esc_html_e('General', 'wd-translator'); ?></button>
        <button type="button" class="wd-translator-tab" data-tab="languages"><?php esc_html_e('Languages', 'wd-translator'); ?></button>
        <button type="button" class="wd-translator-tab" data-tab="appearance"><?php esc_html_e('Appearance', 'wd-translator'); ?></button>
        <button type="button" class="wd-translator-tab" data-tab="cache"><?php esc_html_e('Cache', 'wd-translator'); ?></button>
        <button type="button" class="wd-translator-tab" data-tab="usage"><?php esc_html_e('Usage', 'wd-translator'); ?></button>
        <button type="button" class="wd-translator-tab" data-tab="help"><?php esc_html_e('Help', 'wd-translator'); ?></button>
    </div>

    <form id="wd-translator-settings-form">
        <?php wp_nonce_field('wp_rest', '_wpnonce'); ?>

        <!-- General Tab -->
        <div class="wd-translator-tab-content active" data-tab="general">
            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Translation Settings', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Configure your translation provider and API credentials', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label><?php esc_html_e('Enable Translation', 'wd-translator'); ?></label>
                        <p class="wd-translator-label-description"><?php esc_html_e('Show translator widget on frontend', 'wd-translator'); ?></p>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <label class="wd-translator-switch">
                            <input type="checkbox" id="wd_translator_enabled" name="enabled" <?php checked(get_option('wd_translator_enabled', true)); ?>>
                            <span class="wd-translator-switch-track">
                                <span class="wd-translator-switch-thumb"></span>
                            </span>
                        </label>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label><?php esc_html_e('Translation Provider', 'wd-translator'); ?></label>
                        <p class="wd-translator-label-description"><?php esc_html_e('Choose your translation service', 'wd-translator'); ?></p>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <div class="wd-translator-provider-cards">
                            <label class="wd-translator-provider-card <?php echo $wd_translator_current_provider === 'google' ? 'selected' : ''; ?>">
                                <input type="radio" name="translation_provider" value="google" <?php checked($wd_translator_current_provider, 'google'); ?>>
                                <span class="wd-translator-badge wd-translator-provider-badge"><?php esc_html_e('Free tier', 'wd-translator'); ?></span>
                                <div class="wd-translator-provider-name"><?php esc_html_e('Google Translate', 'wd-translator'); ?></div>
                                <div class="wd-translator-provider-desc"><?php esc_html_e('Fast, reliable translations with 500K chars/month free', 'wd-translator'); ?></div>
                            </label>
                            <label class="wd-translator-provider-card <?php echo $wd_translator_current_provider === 'openai' ? 'selected' : ''; ?>">
                                <input type="radio" name="translation_provider" value="openai" <?php checked($wd_translator_current_provider, 'openai'); ?>>
                                <span class="wd-translator-badge wd-translator-provider-badge"><?php esc_html_e('AI-powered', 'wd-translator'); ?></span>
                                <div class="wd-translator-provider-name"><?php esc_html_e('OpenAI GPT', 'wd-translator'); ?></div>
                                <div class="wd-translator-provider-desc"><?php esc_html_e('More nuanced, context-aware translations', 'wd-translator'); ?></div>
                            </label>
                        </div>

                        <div class="wd-translator-api-config <?php echo $wd_translator_current_provider !== 'google' ? 'wd-translator-hidden' : ''; ?>" id="wd-translator-google-config">
                            <div class="wd-translator-api-config-header">
                                <span class="wd-translator-api-config-title"><?php esc_html_e('Google Cloud API Key', 'wd-translator'); ?></span>
                                <span id="wd-translator-google-key-badge" class="wd-translator-badge wd-translator-badge-success" style="display: none;"><?php esc_html_e('Connected', 'wd-translator'); ?></span>
                            </div>
                            <div class="wd-translator-input-with-button">
                                <input type="password" id="wd_translator_google_api_key" name="google_api_key" placeholder="<?php esc_attr_e('Enter your Google Cloud API key', 'wd-translator'); ?>" value="<?php echo esc_attr(get_option('wd_translator_google_api_key', '')); ?>">
                                <button type="button" id="wd-translator-verify-google-key" class="wd-translator-btn wd-translator-btn-secondary"><?php esc_html_e('Verify', 'wd-translator'); ?></button>
                            </div>
                            <p class="wd-translator-text-sm wd-translator-text-muted wd-translator-mt-2"><?php esc_html_e('Get your API key from console.cloud.google.com (Cloud Translation API)', 'wd-translator'); ?></p>
                            <p id="wd-translator-google-key-status" class="wd-translator-status"></p>
                        </div>

                        <div class="wd-translator-api-config <?php echo $wd_translator_current_provider !== 'openai' ? 'wd-translator-hidden' : ''; ?>" id="wd-translator-openai-config">
                            <div class="wd-translator-api-config-header">
                                <span class="wd-translator-api-config-title"><?php esc_html_e('OpenAI API Key', 'wd-translator'); ?></span>
                                <span id="wd-translator-openai-key-badge" class="wd-translator-badge wd-translator-badge-success" style="display: none;"><?php esc_html_e('Connected', 'wd-translator'); ?></span>
                            </div>
                            <div class="wd-translator-input-with-button">
                                <input type="password" id="wd_translator_openai_api_key" name="openai_api_key" placeholder="sk-..." value="<?php echo esc_attr(get_option('wd_translator_openai_api_key', '')); ?>">
                                <button type="button" id="wd-translator-verify-openai-key" class="wd-translator-btn wd-translator-btn-secondary"><?php esc_html_e('Verify', 'wd-translator'); ?></button>
                            </div>
                            <p class="wd-translator-text-sm wd-translator-text-muted wd-translator-mt-2"><?php esc_html_e('Get your API key from platform.openai.com', 'wd-translator'); ?></p>
                            <p id="wd-translator-openai-key-status" class="wd-translator-status"></p>

                            <div class="wd-translator-mt-4">
                                <label class="wd-translator-mb-2"><?php esc_html_e('Model', 'wd-translator'); ?></label>
                                <select id="wd_translator_openai_model" name="openai_model" style="max-width: 250px;">
                                    <optgroup label="GPT-5.2">
                                        <option value="gpt-5.2" <?php selected(get_option('wd_translator_openai_model', 'gpt-5.2'), 'gpt-5.2'); ?>>GPT-5.2 (<?php esc_html_e('Recommended', 'wd-translator'); ?>)</option>
                                        <option value="gpt-5.2-pro" <?php selected(get_option('wd_translator_openai_model'), 'gpt-5.2-pro'); ?>>GPT-5.2 Pro</option>
                                    </optgroup>
                                    <optgroup label="GPT-4">
                                        <option value="gpt-4o-mini" <?php selected(get_option('wd_translator_openai_model'), 'gpt-4o-mini'); ?>>GPT-4o Mini</option>
                                        <option value="gpt-4o" <?php selected(get_option('wd_translator_openai_model'), 'gpt-4o'); ?>>GPT-4o</option>
                                        <option value="gpt-4-turbo" <?php selected(get_option('wd_translator_openai_model'), 'gpt-4-turbo'); ?>>GPT-4 Turbo</option>
                                    </optgroup>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_source_language"><?php esc_html_e('Source Language', 'wd-translator'); ?></label>
                        <p class="wd-translator-label-description"><?php esc_html_e('Original language of your content', 'wd-translator'); ?></p>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <select id="wd_translator_source_language" name="source_language" style="max-width: 300px;">
                            <?php foreach ($wd_translator_languages as $wd_translator_code => $wd_translator_lang): ?>
                                <option value="<?php echo esc_attr($wd_translator_code); ?>" <?php selected(get_option('wd_translator_source_language', 'en'), $wd_translator_code); ?>>
                                    <?php echo esc_html($wd_translator_lang['name'] . ' (' . $wd_translator_lang['native'] . ')'); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Languages Tab -->
        <div class="wd-translator-tab-content" data-tab="languages">
            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Available Languages', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Select the languages you want to offer for translation', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-language-toolbar">
                    <input type="text" id="wd-translator-language-filter" class="wd-translator-language-search" placeholder="<?php esc_attr_e('Search languages...', 'wd-translator'); ?>">
                    <div class="wd-translator-language-actions">
                        <button type="button" class="wd-translator-btn wd-translator-btn-secondary wd-translator-btn-sm" id="wd-translator-select-all"><?php esc_html_e('Select All', 'wd-translator'); ?></button>
                        <button type="button" class="wd-translator-btn wd-translator-btn-secondary wd-translator-btn-sm" id="wd-translator-select-none"><?php esc_html_e('Select None', 'wd-translator'); ?></button>
                    </div>
                </div>

                <div class="wd-translator-language-grid" id="wd-translator-language-grid">
                    <?php foreach ($wd_translator_languages as $wd_translator_code => $wd_translator_lang):
                        $wd_translator_is_checked = in_array($wd_translator_code, $wd_translator_enabled_languages);
                    ?>
                        <label class="wd-translator-language-item <?php echo $wd_translator_is_checked ? 'selected' : ''; ?>" data-code="<?php echo esc_attr($wd_translator_code); ?>" data-name="<?php echo esc_attr(strtolower($wd_translator_lang['name'])); ?>">
                            <input type="checkbox" name="enabled_languages[]" value="<?php echo esc_attr($wd_translator_code); ?>" <?php checked($wd_translator_is_checked); ?>>
                            <span class="wd-translator-flag wd-translator-flag-<?php echo esc_attr($wd_translator_code); ?>" data-code="<?php echo esc_attr($wd_translator_code); ?>"></span>
                            <div class="wd-translator-language-info">
                                <div class="wd-translator-language-native"><?php echo esc_html($wd_translator_lang['native']); ?></div>
                                <div class="wd-translator-language-english"><?php echo esc_html($wd_translator_lang['name']); ?></div>
                            </div>
                            <button type="button" class="wd-translator-customize-btn" data-code="<?php echo esc_attr($wd_translator_code); ?>" data-native="<?php echo esc_attr($wd_translator_lang['native']); ?>" title="<?php esc_attr_e('Customize', 'wd-translator'); ?>">
                                <span class="dashicons dashicons-admin-generic"></span>
                            </button>
                        </label>
                    <?php endforeach; ?>
                </div>

                <p class="wd-translator-text-sm wd-translator-text-muted wd-translator-mt-4">
                    <span id="wd-translator-selected-count"><?php echo count($wd_translator_enabled_languages); ?></span> <?php esc_html_e('languages selected', 'wd-translator'); ?>
                </p>
            </div>
        </div>

        <!-- Appearance Tab -->
        <div class="wd-translator-tab-content" data-tab="appearance">
            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Widget Style', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Choose how the translator widget appears on your site', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_widget_style"><?php esc_html_e('Widget Style', 'wd-translator'); ?></label>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <select id="wd_translator_widget_style" name="widget_style" style="max-width: 250px;">
                            <option value="floating" <?php selected(get_option('wd_translator_widget_style', 'floating'), 'floating'); ?>><?php esc_html_e('Floating Button', 'wd-translator'); ?></option>
                            <option value="inline" <?php selected(get_option('wd_translator_widget_style'), 'inline'); ?>><?php esc_html_e('Inline Dropdown', 'wd-translator'); ?></option>
                            <option value="flags" <?php selected(get_option('wd_translator_widget_style'), 'flags'); ?>><?php esc_html_e('Flag Grid', 'wd-translator'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="wd-translator-form-row" id="wd-translator-position-row" <?php echo get_option('wd_translator_widget_style', 'floating') !== 'floating' ? 'style="display: none;"' : ''; ?>>
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_widget_position"><?php esc_html_e('Position', 'wd-translator'); ?></label>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <select id="wd_translator_widget_position" name="widget_position" style="max-width: 250px;">
                            <option value="bottom-right" <?php selected(get_option('wd_translator_widget_position', 'bottom-right'), 'bottom-right'); ?>><?php esc_html_e('Bottom Right', 'wd-translator'); ?></option>
                            <option value="bottom-left" <?php selected(get_option('wd_translator_widget_position'), 'bottom-left'); ?>><?php esc_html_e('Bottom Left', 'wd-translator'); ?></option>
                            <option value="top-right" <?php selected(get_option('wd_translator_widget_position'), 'top-right'); ?>><?php esc_html_e('Top Right', 'wd-translator'); ?></option>
                            <option value="top-left" <?php selected(get_option('wd_translator_widget_position'), 'top-left'); ?>><?php esc_html_e('Top Left', 'wd-translator'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label><?php esc_html_e('Show Flag Icons', 'wd-translator'); ?></label>
                        <p class="wd-translator-label-description"><?php esc_html_e('Display flags next to language names', 'wd-translator'); ?></p>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <label class="wd-translator-switch">
                            <input type="checkbox" id="wd_translator_show_flags" name="show_flags" <?php checked(get_option('wd_translator_show_flags', true)); ?>>
                            <span class="wd-translator-switch-track">
                                <span class="wd-translator-switch-thumb"></span>
                            </span>
                        </label>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_language_display"><?php esc_html_e('Language Display', 'wd-translator'); ?></label>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <select id="wd_translator_language_display" name="language_display" style="max-width: 300px;">
                            <option value="native" <?php selected(get_option('wd_translator_language_display', 'native'), 'native'); ?>><?php esc_html_e('Native name (Espanol, Francais)', 'wd-translator'); ?></option>
                            <option value="english" <?php selected(get_option('wd_translator_language_display'), 'english'); ?>><?php esc_html_e('English name (Spanish, French)', 'wd-translator'); ?></option>
                            <option value="code" <?php selected(get_option('wd_translator_language_display'), 'code'); ?>><?php esc_html_e('Language code (ES, FR)', 'wd-translator'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_font_size"><?php esc_html_e('Font Size', 'wd-translator'); ?></label>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <select id="wd_translator_font_size" name="font_size" style="max-width: 200px;">
                            <option value="small" <?php selected(get_option('wd_translator_font_size', 'medium'), 'small'); ?>><?php esc_html_e('Small', 'wd-translator'); ?></option>
                            <option value="medium" <?php selected(get_option('wd_translator_font_size'), 'medium'); ?>><?php esc_html_e('Medium', 'wd-translator'); ?></option>
                            <option value="large" <?php selected(get_option('wd_translator_font_size'), 'large'); ?>><?php esc_html_e('Large', 'wd-translator'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_border_radius"><?php esc_html_e('Border Radius', 'wd-translator'); ?></label>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <select id="wd_translator_border_radius" name="border_radius" style="max-width: 200px;">
                            <option value="none" <?php selected(get_option('wd_translator_border_radius', 'medium'), 'none'); ?>><?php esc_html_e('None', 'wd-translator'); ?></option>
                            <option value="small" <?php selected(get_option('wd_translator_border_radius'), 'small'); ?>><?php esc_html_e('Small', 'wd-translator'); ?></option>
                            <option value="medium" <?php selected(get_option('wd_translator_border_radius'), 'medium'); ?>><?php esc_html_e('Medium', 'wd-translator'); ?></option>
                            <option value="large" <?php selected(get_option('wd_translator_border_radius'), 'large'); ?>><?php esc_html_e('Large', 'wd-translator'); ?></option>
                            <option value="pill" <?php selected(get_option('wd_translator_border_radius'), 'pill'); ?>><?php esc_html_e('Pill', 'wd-translator'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_shadow"><?php esc_html_e('Shadow', 'wd-translator'); ?></label>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <select id="wd_translator_shadow" name="shadow" style="max-width: 200px;">
                            <option value="none" <?php selected(get_option('wd_translator_shadow', 'subtle'), 'none'); ?>><?php esc_html_e('None', 'wd-translator'); ?></option>
                            <option value="subtle" <?php selected(get_option('wd_translator_shadow'), 'subtle'); ?>><?php esc_html_e('Subtle', 'wd-translator'); ?></option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Colors', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Customize the widget color scheme', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-color-grid">
                    <div class="wd-translator-color-field">
                        <label for="wd_translator_bg_color"><?php esc_html_e('Background', 'wd-translator'); ?></label>
                        <input type="text" id="wd_translator_bg_color" name="bg_color" class="wd-translator-color-picker" value="<?php echo esc_attr(get_option('wd_translator_bg_color', '#ffffff')); ?>">
                    </div>
                    <div class="wd-translator-color-field">
                        <label for="wd_translator_text_color"><?php esc_html_e('Text', 'wd-translator'); ?></label>
                        <input type="text" id="wd_translator_text_color" name="text_color" class="wd-translator-color-picker" value="<?php echo esc_attr(get_option('wd_translator_text_color', '#374151')); ?>">
                    </div>
                    <div class="wd-translator-color-field">
                        <label for="wd_translator_border_color"><?php esc_html_e('Border', 'wd-translator'); ?></label>
                        <input type="text" id="wd_translator_border_color" name="border_color" class="wd-translator-color-picker" value="<?php echo esc_attr(get_option('wd_translator_border_color', '#e5e7eb')); ?>">
                    </div>
                    <div class="wd-translator-color-field">
                        <label for="wd_translator_hover_bg_color"><?php esc_html_e('Hover', 'wd-translator'); ?></label>
                        <input type="text" id="wd_translator_hover_bg_color" name="hover_bg_color" class="wd-translator-color-picker" value="<?php echo esc_attr(get_option('wd_translator_hover_bg_color', '#f9fafb')); ?>">
                    </div>
                    <div class="wd-translator-color-field">
                        <label for="wd_translator_active_bg_color"><?php esc_html_e('Active', 'wd-translator'); ?></label>
                        <input type="text" id="wd_translator_active_bg_color" name="active_bg_color" class="wd-translator-color-picker" value="<?php echo esc_attr(get_option('wd_translator_active_bg_color', '#f3f4f6')); ?>">
                    </div>
                </div>
            </div>

        </div>

        <!-- Cache Tab -->
        <div class="wd-translator-tab-content" data-tab="cache">
            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Cache Settings', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Configure translation caching to reduce API calls', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label><?php esc_html_e('Enable Cache', 'wd-translator'); ?></label>
                        <p class="wd-translator-label-description"><?php esc_html_e('Store translations to improve performance', 'wd-translator'); ?></p>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <label class="wd-translator-switch">
                            <input type="checkbox" id="wd_translator_cache_enabled" name="cache_enabled" <?php checked(get_option('wd_translator_cache_enabled', true)); ?>>
                            <span class="wd-translator-switch-track">
                                <span class="wd-translator-switch-thumb"></span>
                            </span>
                        </label>
                    </div>
                </div>

                <div class="wd-translator-form-row">
                    <div class="wd-translator-form-label-group">
                        <label for="wd_translator_cache_ttl"><?php esc_html_e('Cache Duration', 'wd-translator'); ?></label>
                        <p class="wd-translator-label-description"><?php esc_html_e('How long to keep cached translations', 'wd-translator'); ?></p>
                    </div>
                    <div class="wd-translator-form-control-group">
                        <div style="display: flex; align-items: center; gap: 8px;">
                            <input type="number" id="wd_translator_cache_ttl" name="cache_ttl" min="1" max="365" value="<?php echo esc_attr(get_option('wd_translator_cache_ttl', 7)); ?>" style="width: 80px;">
                            <span class="wd-translator-text-muted"><?php esc_html_e('days', 'wd-translator'); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Cache Statistics', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Current cache usage and performance', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-stats-grid">
                    <div class="wd-translator-stat-card">
                        <div class="wd-translator-stat-label"><?php esc_html_e('Cached Entries', 'wd-translator'); ?></div>
                        <div class="wd-translator-stat-value" id="wd-translator-stat-entries">-</div>
                    </div>
                    <div class="wd-translator-stat-card">
                        <div class="wd-translator-stat-label"><?php esc_html_e('Cache Hits', 'wd-translator'); ?></div>
                        <div class="wd-translator-stat-value" id="wd-translator-stat-hits">-</div>
                    </div>
                    <div class="wd-translator-stat-card">
                        <div class="wd-translator-stat-label"><?php esc_html_e('Languages', 'wd-translator'); ?></div>
                        <div class="wd-translator-stat-value" id="wd-translator-stat-languages">-</div>
                    </div>
                </div>

                <div class="wd-translator-mt-4">
                    <button type="button" id="wd-translator-clear-cache" class="wd-translator-btn wd-translator-btn-destructive"><?php esc_html_e('Clear All Cache', 'wd-translator'); ?></button>
                    <span id="wd-translator-cache-status" class="wd-translator-status"></span>
                </div>
            </div>
        </div>

        <!-- Usage Tab -->
        <div class="wd-translator-tab-content" data-tab="usage">
            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Shortcodes', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Add the translator widget anywhere using shortcodes', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-shortcode-table">
                    <div class="wd-translator-shortcode-row">
                        <div class="wd-translator-shortcode-code-col">
                            <code class="wd-translator-shortcode-code">[wd_translator]</code>
                        </div>
                        <div class="wd-translator-shortcode-desc-col">
                            <div class="wd-translator-shortcode-title"><?php esc_html_e('Default Widget', 'wd-translator'); ?></div>
                            <div class="wd-translator-shortcode-desc"><?php esc_html_e('Displays the translator using your configured widget style (floating, inline, or flags)', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-shortcode-row">
                        <div class="wd-translator-shortcode-code-col">
                            <code class="wd-translator-shortcode-code">[wd_translator style="inline"]</code>
                        </div>
                        <div class="wd-translator-shortcode-desc-col">
                            <div class="wd-translator-shortcode-title"><?php esc_html_e('Inline Dropdown', 'wd-translator'); ?></div>
                            <div class="wd-translator-shortcode-desc"><?php esc_html_e('A compact dropdown selector that blends with your content. Great for headers or navigation menus.', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-shortcode-row">
                        <div class="wd-translator-shortcode-code-col">
                            <code class="wd-translator-shortcode-code">[wd_translator style="flags"]</code>
                        </div>
                        <div class="wd-translator-shortcode-desc-col">
                            <div class="wd-translator-shortcode-title"><?php esc_html_e('Flag Grid', 'wd-translator'); ?></div>
                            <div class="wd-translator-shortcode-desc"><?php esc_html_e('Visual grid of country flags. Best for footer sections or dedicated language pages.', 'wd-translator'); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Automatic Widget', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('The floating widget appears automatically when enabled', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-info-box">
                    <p><?php
                        printf(
                            /* translators: %1$s and %2$s are opening and closing strong tags */
                            esc_html__('When %1$sEnable Translation%2$s is turned on and %1$sWidget Style%2$s is set to "Floating Button", the translator will automatically appear on all pages of your site.', 'wd-translator'),
                            '<strong>',
                            '</strong>'
                        );
                    ?></p>
                    <p><?php esc_html_e('No shortcode needed for the floating widget - it\'s added automatically.', 'wd-translator'); ?></p>
                </div>
            </div>

            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('How It Works', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Understanding the translation process', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-steps-list">
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">1</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Visitor selects a language', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Using the widget dropdown or flag grid', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">2</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Page content is extracted', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Text nodes are collected while preserving HTML structure', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">3</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Translation request is sent', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Via your configured provider (Google or OpenAI)', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">4</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Translations are cached', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Stored in database to reduce API calls and costs', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">5</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Page updates instantly', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Content is replaced without page reload', 'wd-translator'); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Help Tab -->
        <div class="wd-translator-tab-content" data-tab="help">
            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Google Cloud Translation API Setup', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Follow these steps to get your Google Cloud API key', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-steps-list">
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">1</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Create a Google Cloud Account', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php
                                printf(
                                    /* translators: %1$s and %2$s are opening and closing anchor tags */
                                    esc_html__('Go to %1$sconsole.cloud.google.com%2$s and sign in with your Google account. New users get $300 in free credits.', 'wd-translator'),
                                    '<a href="https://console.cloud.google.com" target="_blank" rel="noopener">',
                                    '</a>'
                                );
                            ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">2</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Create a New Project', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Click the project dropdown at the top of the page, then "New Project". Give it a name like "Website Translation" and click Create.', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">3</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Enable the Cloud Translation API', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php
                                printf(
                                    /* translators: %1$s and %2$s are opening and closing strong tags */
                                    esc_html__('Go to %1$sAPIs & Services > Library%2$s, search for "Cloud Translation API", click on it, and press the "Enable" button.', 'wd-translator'),
                                    '<strong>',
                                    '</strong>'
                                );
                            ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">4</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Create API Credentials', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php
                                printf(
                                    /* translators: %1$s and %2$s are opening and closing strong tags */
                                    esc_html__('Go to %1$sAPIs & Services > Credentials%2$s, click "Create Credentials" and select "API key".', 'wd-translator'),
                                    '<strong>',
                                    '</strong>'
                                );
                            ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">5</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Select Credential Type', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php
                                printf(
                                    /* translators: %1$s and %2$s are opening and closing strong tags */
                                    esc_html__('When asked "Which API are you using?", select %1$sCloud Translation API%2$s. For "What data will you be accessing?", choose %1$sPublic data%2$s (this creates an API key). Click Next and your API key will be generated.', 'wd-translator'),
                                    '<strong>',
                                    '</strong>'
                                );
                            ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">6</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Restrict Your API Key (Recommended)', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Click "Edit API key", under "API restrictions" select "Restrict key" and choose only "Cloud Translation API". Under "Application restrictions", consider restricting to your website\'s domain for security.', 'wd-translator'); ?></div>
                        </div>
                    </div>
                </div>

                <div class="wd-translator-info-box wd-translator-mt-4">
                    <p><strong><?php esc_html_e('Free Tier:', 'wd-translator'); ?></strong> <?php esc_html_e('Google offers 500,000 characters per month free. After that, pricing is $20 per million characters.', 'wd-translator'); ?></p>
                </div>
            </div>

            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('OpenAI API Setup', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Follow these steps to get your OpenAI API key', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-steps-list">
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">1</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Create an OpenAI Account', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php
                                printf(
                                    /* translators: %1$s and %2$s are opening and closing anchor tags */
                                    esc_html__('Go to %1$splatform.openai.com%2$s and sign up for an account or log in if you already have one.', 'wd-translator'),
                                    '<a href="https://platform.openai.com" target="_blank" rel="noopener">',
                                    '</a>'
                                );
                            ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">2</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Navigate to API Keys', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php
                                printf(
                                    /* translators: %1$s and %2$s are opening and closing strong tags */
                                    esc_html__('Click on your profile icon in the top-right corner, then go to %1$sAPI keys%2$s from the dropdown menu (or visit platform.openai.com/api-keys directly).', 'wd-translator'),
                                    '<strong>',
                                    '</strong>'
                                );
                            ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">3</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Create a New Secret Key', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Click "Create new secret key", give it a name like "WD Translator", and click Create. Your key will be displayed once - copy it immediately!', 'wd-translator'); ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">4</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Add Billing (Required)', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php
                                printf(
                                    /* translators: %1$s and %2$s are opening and closing strong tags */
                                    esc_html__('Go to %1$sSettings > Billing%2$s and add a payment method. OpenAI requires billing to be set up before you can use the API. You can set usage limits to control costs.', 'wd-translator'),
                                    '<strong>',
                                    '</strong>'
                                );
                            ?></div>
                        </div>
                    </div>
                    <div class="wd-translator-step-item">
                        <div class="wd-translator-step-number">5</div>
                        <div class="wd-translator-step-content">
                            <div class="wd-translator-step-title"><?php esc_html_e('Save Your Key Securely', 'wd-translator'); ?></div>
                            <div class="wd-translator-step-desc"><?php esc_html_e('Store your API key in a secure location. You won\'t be able to view it again in OpenAI\'s dashboard. If you lose it, you\'ll need to create a new one.', 'wd-translator'); ?></div>
                        </div>
                    </div>
                </div>

                <div class="wd-translator-info-box wd-translator-mt-4">
                    <p><strong><?php esc_html_e('Pricing:', 'wd-translator'); ?></strong> <?php esc_html_e('OpenAI charges based on tokens used. GPT-5.2 costs approximately $5 per million input tokens and $15 per million output tokens. Set spending limits in your OpenAI dashboard to control costs.', 'wd-translator'); ?></p>
                </div>
            </div>

            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Which Provider Should I Choose?', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Compare Google Translate vs OpenAI GPT', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-comparison-table">
                    <table class="wd-translator-table">
                        <thead>
                            <tr>
                                <th><?php esc_html_e('Feature', 'wd-translator'); ?></th>
                                <th><?php esc_html_e('Google Translate', 'wd-translator'); ?></th>
                                <th><?php esc_html_e('OpenAI GPT', 'wd-translator'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?php esc_html_e('Speed', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('Very fast', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('Moderate', 'wd-translator'); ?></td>
                            </tr>
                            <tr>
                                <td><?php esc_html_e('Free Tier', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('500K chars/month', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('None (pay as you go)', 'wd-translator'); ?></td>
                            </tr>
                            <tr>
                                <td><?php esc_html_e('Quality', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('Good for most content', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('Better context awareness', 'wd-translator'); ?></td>
                            </tr>
                            <tr>
                                <td><?php esc_html_e('Best For', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('High volume, budget-conscious', 'wd-translator'); ?></td>
                                <td><?php esc_html_e('Nuanced, marketing content', 'wd-translator'); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="wd-translator-info-box wd-translator-mt-4">
                    <p><strong><?php esc_html_e('Recommendation:', 'wd-translator'); ?></strong> <?php esc_html_e('Start with Google Translate for its free tier. Switch to OpenAI if you need more natural-sounding translations for marketing or creative content.', 'wd-translator'); ?></p>
                </div>
            </div>

            <div class="wd-translator-card">
                <div class="wd-translator-card-header">
                    <h2 class="wd-translator-card-title"><?php esc_html_e('Need More Help?', 'wd-translator'); ?></h2>
                    <p class="wd-translator-card-description"><?php esc_html_e('Additional resources and support', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-help-links">
                    <a href="https://cloud.google.com/translate/docs" target="_blank" rel="noopener" class="wd-translator-help-link">
                        <span class="wd-translator-help-link-icon dashicons dashicons-external"></span>
                        <span class="wd-translator-help-link-text"><?php esc_html_e('Google Cloud Translation Documentation', 'wd-translator'); ?></span>
                    </a>
                    <a href="https://platform.openai.com/docs" target="_blank" rel="noopener" class="wd-translator-help-link">
                        <span class="wd-translator-help-link-icon dashicons dashicons-external"></span>
                        <span class="wd-translator-help-link-text"><?php esc_html_e('OpenAI API Documentation', 'wd-translator'); ?></span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="wd-translator-settings-footer">
            <button type="submit" class="wd-translator-btn wd-translator-btn-primary"><?php esc_html_e('Save Settings', 'wd-translator'); ?></button>
            <span id="wd-translator-save-status" class="wd-translator-status"></span>
        </div>
    </form>

    <!-- Language Customization Modal -->
    <div id="wd-translator-customize-modal" class="wd-translator-modal" style="display: none;">
        <div class="wd-translator-modal-overlay"></div>
        <div class="wd-translator-modal-content">
            <div class="wd-translator-modal-header">
                <h3 id="wd-translator-modal-title"><?php esc_html_e('Customize Language', 'wd-translator'); ?></h3>
                <button type="button" class="wd-translator-modal-close">&times;</button>
            </div>
            <div class="wd-translator-modal-body">
                <input type="hidden" id="wd-translator-customize-code" value="">

                <div class="wd-translator-form-group">
                    <label for="wd-translator-custom-label"><?php esc_html_e('Custom Label', 'wd-translator'); ?></label>
                    <input type="text" id="wd-translator-custom-label" class="wd-translator-input" placeholder="<?php esc_attr_e('e.g., Español (México)', 'wd-translator'); ?>">
                    <p class="wd-translator-form-hint"><?php esc_html_e('Leave empty to use default label based on display settings.', 'wd-translator'); ?></p>
                </div>

                <div class="wd-translator-form-group">
                    <label><?php esc_html_e('Custom Flag', 'wd-translator'); ?></label>
                    <div class="wd-translator-flag-upload">
                        <div id="wd-translator-flag-preview" class="wd-translator-flag-preview"></div>
                        <div class="wd-translator-flag-buttons">
                            <button type="button" id="wd-translator-select-flag" class="wd-translator-btn wd-translator-btn-secondary"><?php esc_html_e('Select Image', 'wd-translator'); ?></button>
                            <button type="button" id="wd-translator-remove-flag" class="wd-translator-btn wd-translator-btn-ghost" style="display: none;"><?php esc_html_e('Remove', 'wd-translator'); ?></button>
                        </div>
                    </div>
                    <input type="hidden" id="wd-translator-custom-flag-id" value="0">
                    <p class="wd-translator-form-hint"><?php esc_html_e('Recommended: 24x18px PNG or SVG.', 'wd-translator'); ?></p>
                </div>
            </div>
            <div class="wd-translator-modal-footer">
                <button type="button" class="wd-translator-btn wd-translator-btn-secondary wd-translator-modal-cancel"><?php esc_html_e('Cancel', 'wd-translator'); ?></button>
                <button type="button" class="wd-translator-btn wd-translator-btn-primary" id="wd-translator-save-customization"><?php esc_html_e('Save', 'wd-translator'); ?></button>
            </div>
        </div>
    </div>
</div>
