<?php
/*
Plugin Name: WCSociality

Description: Рейтинг постов и страниц, кнопка "лайка", а также вопрос "Полезна ли эта статья?" в одном плагине.

Text Domain: wcs
Domain Path: /lang

Version: 1.0
Author: po5epT
Author URI: http://po5ept.ru
Plugin URI: http://po5ept.ru/wp-plugins/wcsociality.html

License: GPL2

Copyright 2017  po5epT  (email : order@wcoder.ru)
*/

if(!defined('ABSPATH')){
	return;
}

define('WC_S_VERSION', '1.0');

define('WC_S_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WC_S_PLUGIN_URL', plugin_dir_url(__FILE__));

define('WC_S_PLUGIN_NN', 'wcs_ajax_nonce');
define('WC_S_PLUGIN_NV', 'wcsSocialityAjaxHandler');

define('WC_S_PLUGIN_URL_AD', 'admin.php');
define('WC_S_PLUGIN_PAGE_AD', 'wcs-settings');

require_once(WC_S_PLUGIN_DIR . 'inc/WCS_Config.php');

require_once(WC_S_PLUGIN_DIR . 'inc/WCSociality.php');
require_once(WC_S_PLUGIN_DIR . 'inc/WCS_Rating.php');
require_once(WC_S_PLUGIN_DIR . 'inc/WCS_Liker.php');
require_once(WC_S_PLUGIN_DIR . 'inc/WCS_Useful.php');

add_action('plugins_loaded', 'wc_s_init', 10);
function wc_s_init(){	
	// Добавляем хуки для загрузки своих стилей и скриптов
	add_action('wp_enqueue_scripts', 'wc_s_load_styles');
    add_action('wp_enqueue_scripts', 'wc_s_load_scripts');   
    // Добавляем хуки для загрузки своих стилей и скриптов в админке
    add_action('admin_enqueue_scripts', 'wc_s_load_admin_styles');
	add_action('admin_enqueue_scripts', 'wc_s_load_admin_scripts');       
    // Добавляем хуки на обработчик ajax-запросов
    add_action('wp_ajax_wcs_sociality','wc_s_ajax_handler');
	add_action('wp_ajax_nopriv_wcs_sociality', 'wc_s_ajax_handler');	
	// Добаляем новую страницу в админку
	add_action('admin_menu', 'wc_s_admin_add_settings_page');
	
	WCS_Config::wcs_set_default_settings();
	
	if(!defined('DOING_AJAX'))
		load_plugin_textdomain('wcs', false, dirname(plugin_basename(__FILE__)) . '/lang/');
}


function wc_s_load_admin_styles(){
	// подключаем IRIS
	wp_enqueue_style('wp-color-picker');
	// подключаем Font Awesome
	wp_enqueue_style('faa', WC_S_PLUGIN_URL . 'css/font-awesome.min.css', array(), WC_S_VERSION);
	// подключаем свой файл стилей
    wp_enqueue_style('wcsa', WC_S_PLUGIN_URL . 'css/wcs-admin.css', array(), WC_S_VERSION);   
}

function wc_s_load_admin_scripts(){
	// подключаем IRIS
	wp_enqueue_script( 'wp-color-picker' );	
	// подключаем свой файл скрипта
	wp_enqueue_script('wcs', WC_S_PLUGIN_URL . 'js/wcs-admin.js', array('jquery', 'wp-color-picker'), false, 1);
}


function wc_s_admin_add_settings_page(){
	add_menu_page(__('WCS Settings', 'wcs'), __('WCS Settings', 'wcs'), 'manage_options', 'wcs-settings', 'wc_s_admin_setting_page');		
}


function wc_s_admin_setting_page(){	
	require_once(WC_S_PLUGIN_DIR . 'inc/admin/functions.php');
	?>
	
	<div class="wrap">			
		<?php wc_s_settings_pages(); ?>	
	</div>
	
	<?php
}


/*
** #Function - загружает стили плагина
*/
function wc_s_load_styles(){
	wp_enqueue_style('fa', WC_S_PLUGIN_URL . 'css/font-awesome.min.css', array(), WC_S_VERSION);
    wp_enqueue_style('wcs', WC_S_PLUGIN_URL . 'css/wcs-style.css', array(), WC_S_VERSION);
}


/*
** #Function - загружает js-скрипты плагина
*/
function wc_s_load_scripts(){

    wp_enqueue_script( 'jquery' );
    
    wp_enqueue_script('wcs', WC_S_PLUGIN_URL . 'js/wcs-main.js', array('jquery'), WC_S_VERSION, true);
    wp_localize_script('wcs', 'wcs_ajax', array('url' => admin_url('admin-ajax.php')));
}



/* 
** #Function - общий ajax-обработчик, проверяет реферера 
** и вызывает обработчик для конкретного действия (рейтинг, лайк, полезность)
*/
function wc_s_ajax_handler(){
    	    
    if(!check_ajax_referer(WC_S_PLUGIN_NV, WC_S_PLUGIN_NN, false)){
    	echo json_encode(array(
	    	'success' => false,
	    	'data'    => array(WC_S_PLUGIN_NN),
	    	'message' => __('Access Denied!', 'wcs')
    	));
    	wp_die();
    }
    
    $postID = abs(intval($_REQUEST['id']));
       
    if($postID == 0){
	    echo json_encode(array(
	    	'success' => false,
	    	'data'    => array($postID),
	    	'message' => __('Post ID is undefined', 'wcs')
    	));
    	wp_die();
    }
 
    $type = sanitize_text_field($_REQUEST['type']);
    
    switch($type){
	    case 'rating':
	    	wc_s_ajax_rating_handler($postID, $type);
	    	break;
	    
	    case 'liker':
	    	wc_s_ajax_liker_handler($postID, $type);
	    	break;
	    	
	    case 'useful':
	    	wc_s_ajax_useful_handler($postID, $type);
	    	break;	
    }	    
    
}


/*
** #Function - ajax-обработчик для рейтинга
*/
function wc_s_ajax_rating_handler($postID, $type){
    
    $rated = abs(intval($_REQUEST['rated']));
	 
	if($rated == 0){
		echo json_encode(array(
			'success' => false,
			'data'	  => array($rated),
			'message' => __('The score can not be 0 or null', 'wcs')
		));
		wp_die();
	}    

	$rating = wc_s_set_instance('rating', $postID, $rated);
			
	echo json_encode(array(
    	'success' => true,
    	'data'    => $rating,
    	'message' => __('Thank you! Your vote is counted', 'wcs')
	));
	wp_die();
}


/*
** #Function - ajax-обработчик для лайков
*/
function wc_s_ajax_liker_handler($postID, $type){
	
	$liked = abs(intval($_REQUEST['liked']));

	if($liked != 1){
	    echo json_encode(array(
	    	'success' => false,
	    	'data'	  => array($liked),
	    	'message' => __('Request is incorrect', 'wcs')
    	));
    	wp_die();
    }
		
	$liker = wc_s_set_instance('liker', $postID);
    
	echo json_encode(array(
    	'success' => true,
    	'data'    => $liker,
    	'message' => __('Thank you! Your vote is counted', 'wcs')
	));
	wp_die();
}


/*
** #Function - ajax-обработчик для полезности
*/
function wc_s_ajax_useful_handler($postID, $type){
	
	$usedo = sanitize_text_field($_REQUEST['usedo']);
		
	$useful = wc_s_set_instance('useful', $postID, $usedo);

	echo json_encode(array(
    	'success' => true,
    	'data'    => $useful,
    	'message' => __('Thank you! Your vote is counted', 'wcs')
	));
	wp_die();
}


/*
** #Function - получает экземпляр указанного класса $name, для поста с ID - $postID
*/
function wc_s_get_instance($name, $postID = 0){
	
	$className = 'WCS_' . ucfirst($name);
	
	 if(!class_exists($className))
    	return false;
	
	return new $className($postID);
}


/*
** #Function - перезаписывает значения указанного объекта
*/
function wc_s_set_instance($name, $postID, $param = 0){	    
    
    $instance = wc_s_get_instance($name, $postID);
    if($param){
    	$instance->wcs_save($param);
	} else {
		$instance->wcs_save();
	}
    return $instance;
}


/*
** #Function - выводит на экран (рейтинг, лайки, полезность) по переданному $type
*/
function wc_s_display($type = 'rating', $postID = 0){
     
    $filePath = WC_S_PLUGIN_DIR . 'template/' . $type . '.php';
    	
    if(!file_exists($filePath))
    	return false;	
    
    $$type = wc_s_get_instance($type, $postID);
	
	WCS_Config::wcs_print_styles();
	
    require($filePath);
}


function the_wc_s_rating($postID = 0) {
	wc_s_display('rating', $postID);
}

function the_wc_s_liker($postID = 0) {
	wc_s_display('liker', $postID);
}

function the_wc_s_useful($postID = 0) {
	wc_s_display('useful', $postID);
}