<?php 
	$settings = WCS_Config::wcs_get_settings($current); 
	$defaults = WCS_Config::wcs_get_default_settings($current);
?>
<h2>
<?php 
switch($current){
	case 'liker':
		_e('Options of Like', 'wcs');
		break;
	case 'useful':
		_e('Options of Useful', 'wcs');
		break;
	default:
		_e('Options of Rating', 'wcs');
} 
?>
</h2>
<table class="form-table">
	<tbody>
		<tr>
			<td>
				<?php require_once(WC_S_PLUGIN_DIR . 'template/admin/' . $current . '.php'); ?>
				<p class="description"><?php _e('Use this function for display on the page ', 'wcs'); ?> <b>the_wc_s_<?php echo $current; ?>();</b></p>
			</td>
		</tr>
		<tr class="wcsa-section">
			<th scope="row">
				<b><?php _e('Icon', 'wcs'); ?></b>
				<p class="description"><?php _e('Options of icon: color and size', 'wcs'); ?></p>
			</th>
		</tr>
		<tr>
			<td>
				<table>
					<?php if($current == 'useful'): ?>
					<tr>
						<th>
							<label for="wcss-<?php echo $current; ?>-color"><?php _e('Like color', 'wcs'); ?></label>
						</th>
						<td>
							<input class="color" name="wcss-<?php echo $current; ?>-color[]" type="text" id="wcss-<?php echo $current; ?>-color" value="<?php echo $settings['color'][0]; ?>" class="regular-text">
							<span class="description"><?php _e('Default color is ', 'wcs'); ?> "<?php echo $defaults['color'][0]; ?>"</span>
						</td>
					</tr>
					<tr>
						<th>
							<label for="wcss-<?php echo $current; ?>-color"><?php _e('Dislike color', 'wcs'); ?></label>
						</th>
						<td>
							<input class="color" name="wcss-<?php echo $current; ?>-color[]" type="text" id="wcss-<?php echo $current; ?>-color" value="<?php echo $settings['color'][1]; ?>" class="regular-text">
							<span class="description"><?php _e('Default color is ', 'wcs'); ?> "<?php echo $defaults['color'][1]; ?>"</span>
						</td>
					</tr>
					<?php else: ?>
					<tr>
						<th>
							<label for="wcss-<?php echo $current; ?>-color"><?php _e('Color', 'wcs'); ?></label>
						</th>
						<td>
							<input class="color" name="wcss-<?php echo $current; ?>-color" type="text" id="wcss-<?php echo $current; ?>-color" value="<?php echo esc_attr($settings['color']); ?>" class="regular-text">
							<span class="description"><?php _e('Default color is ', 'wcs'); ?> "<?php echo $defaults['color']; ?>"</span>
						</td>
					</tr>
					<?php endif; ?>
					<tr>
						<th>
							<label for="wcss-<?php echo $current; ?>-size"><?php _e('Size', 'wcs'); ?></label>
						</th>
						<td>
							<input name="wcss-<?php echo $current; ?>-size" type="text" id="wcss-<?php echo $current; ?>-size" value="<?php echo esc_attr($settings['size']); ?>" class="regular-text">
							<span class="description"><?php _e('Default size is ', 'wcs'); ?> <?php echo $defaults['size']; ?>px</span>
						</td>
					</tr>
				</table>
			</td>
		</tr>				
		<tr  class="wcsa-section">
			<th scope="row">
				<b><?php _e('Text before icon', 'wcs'); ?></b>
				<p class="description"><?php _e('Options of text before icon: text, color, size', 'wcs'); ?></p>
			</th>
		</tr>
		<tr>	
			<td>
				<table>
					<tr>
						<th scope="row">
							<label for="wcss-<?php echo $current; ?>-text"><?php _e('Text', 'wcs'); ?></label>
						</th>
						<td>
							<input name="wcss-<?php echo $current; ?>-text" type="text" id="wcss-<?php echo $current; ?>-text" value="<?php echo esc_attr($settings['text']); ?>" class="regular-text">
							<span class="description">
								<?php _e('Default text is ', 'wcs'); ?> 
								<?php 
									switch($current){
										case 'liker':
											_e('I like', 'wcs');
											break;
										case 'useful':
											_e('Is this article useful?', 'wcs');
											break;
										default:
											_e('Rating', 'wcs');
									}									 
								?>
							</span>
						</td>
					</tr>
					<tr>
						<th>
							<label for="wcss-<?php echo $current; ?>-text-color"><?php _e('Color', 'wcs'); ?></label>
						</th>
						<td>
							<input class="color" name="wcss-<?php echo $current; ?>-text-color" type="text" id="wcss-<?php echo $current; ?>-text-color" value="<?php echo esc_attr($settings['text-color']); ?>" class="regular-text">
							<span class="description"><?php _e('Default color is ', 'wcs'); ?> "<?php echo $defaults['text-color']; ?>"</span>
						</td>
					</tr>
					<tr>
						<th>
							<label for="wcss-<?php echo $current; ?>-text-size"><?php _e('Size', 'wcs'); ?></label>
						</th>
						<td>
							<input name="wcss-<?php echo $current; ?>-text-size" type="text" id="wcss-<?php echo $current; ?>-text-size" value="<?php echo esc_attr($settings['text-size']); ?>" class="regular-text">
							<span class="description"><?php _e('Default size is ', 'wcs'); ?> <?php echo $defaults['text-size']; ?>px</span>
						</td>
					</tr>
				</table>
			</td>	
		</tr>
		<tr  class="wcsa-section">
			<th scope="row">
				<b><?php _e('Block', 'wcs'); ?></b>
				<p class="description"><?php _e('Options of block: background, border', 'wcs'); ?></p>
			</th>
		</tr>
		<tr>	
			<td>
				<table>
					<tr>
						<th scope="row">
							<label for="wcss-<?php echo $current; ?>-bg"><?php _e('Background', 'wcs'); ?></label>
						</th>
						<td>
							<input class="color" name="wcss-<?php echo $current; ?>-bg" type="text" id="wcss-<?php echo $current; ?>-bg" value="<?php echo esc_attr($settings['bg']); ?>" class="regular-text">
							<span class="description"><?php _e('Default background is ', 'wcs'); ?> "<?php echo $defaults['bg']; ?>"</span>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="wcss-<?php echo $current; ?>-border"><?php _e('Border color', 'wcs'); ?></label>
						</th>
						<td>
							<input class="color" name="wcss-<?php echo $current; ?>-border" type="text" id="wcss-<?php echo $current; ?>-border" value="<?php echo esc_attr($settings['border']); ?>" class="regular-text">
							<span class="description"><?php _e('Default border color is ', 'wcs'); ?> "<?php echo $defaults['border']; ?>"</span>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</tbody>
</table>