(function($) {

	$('.wcs-rating-stars').on('mouseenter mouseleave', function(event){
		
		var wcs_rating_container = $(this).parent();
		if(wcs_rating_container.hasClass('disabled'))
	    	return false;
		
		switch(event.type){
			case 'mouseenter':
				window.wcs_stars_filled = $(this).find('.star-filled');
				window.wcs_stars_halfed = $(this).find('.star-halfed');
				$(this).find('.star-filled').removeClass('star-filled');
				$(this).find('.star-halfed').removeClass('star-halfed');
				break;
			case 'mouseleave':
				window.wcs_stars_filled.addClass('star-filled');
				window.wcs_stars_halfed.addClass('star-halfed');
				break;
		}		
	});
	
    $('.wcs-rating input').on('change', function(){
	    
	    var wcs_rating_container = $(this).parent().parent();
	    
	    if(wcs_rating_container.hasClass('disabled'))
	    	return false;
	    
        var wcs_rate = $(this).val(),        	
        	wcs_rating_post_id = wcs_rating_container.data('rating'),
        	wcs_ajax_nonce = $('[name="wcs_ajax_nonce"]').val(),
        	wcs_rating_data = {
			   action: 'wcs_sociality', 
			   id: wcs_rating_post_id, 
			   rated: wcs_rate, 
			   wcs_ajax_nonce: wcs_ajax_nonce,
			   type: 'rating'
			};
		
		console.log(wcs_rating_data);	
			
        $.ajax({
			type: 'POST',
			url: wcs_ajax.url,
			data: wcs_rating_data,
			dataType: 'json',
			success: function(response){
				//console.log(response);
				if(response.success){
					$('.wcs-rating-score').html(response.data.score);
					$('.wcs-rating-voted').html(response.data.voted);
					
					wcs_rating_container.addClass('disabled');
				}
			} 
        });   
    });

    

    $('.wcs-liker input').on('change', function(event){
	    
	    var wcs_liker_container = $(this).parent();
	    
	    if(wcs_liker_container.hasClass('disabled'))
	    	return false;
	    
        var wcs_liker_post_id = wcs_liker_container.data('liker'),
        	wcs_ajax_nonce = $('[name="wcs_ajax_nonce"]').val(),
        	wcs_liker_data = {
			   action: 'wcs_sociality', 
			   id: wcs_liker_post_id, 
			   liked: 1, 
			   wcs_ajax_nonce: wcs_ajax_nonce,
			   type: 'liker'
			};
	
		

		$.ajax({
			type: 'POST',
			url: wcs_ajax.url,
			data: wcs_liker_data,
			dataType: 'json',
			success: function(response){

				if(response.success){
					$('.wcs-liker-count').html(response.data.liked);
					wcs_liker_container.addClass('disabled');
				}	
				else {
					/*** ... ***/
				}	
			} 
        });
		
    });

    
    
    $('.wcs-useful input').on('change', function(event){
	    
	    var wcs_useful_container = $(this).parent(),
	    	wcs_useful_key = $(this).val();
	    
	    if(wcs_useful_container.hasClass('disabled'))
	    	return false;
	    
        var wcs_useful_post_id = wcs_useful_container.data('useful'),
        	wcs_ajax_nonce = $('[name="wcs_ajax_nonce"]').val(),
        	wcs_useful_data = {
			   action: 'wcs_sociality', 
			   id: wcs_useful_post_id, 
			   usedo: wcs_useful_key, 
			   wcs_ajax_nonce: wcs_ajax_nonce,
			   type: 'useful'
			};
						
		

		$.ajax({
			type: 'POST',
			url: wcs_ajax.url,
			data: wcs_useful_data,
			dataType: 'json',
			success: function(response){

				if(response.success){					
					if(wcs_useful_key == 'positive' || wcs_useful_key == 'negative'){
						$('.wcs-' + wcs_useful_key + '-count').html(response.data[wcs_useful_key]);
						wcs_useful_container.addClass('disabled');
					}
				}	
				else {
					/*** ... ***/
				}	
			} 
        });
		
    }); 
    
})(jQuery);