<?php
function wc_s_settings_tabs($current = 'rating') {
    
    $html = '';
    $tabs = array(
    	'rating' => __('Rating', 'wcs'), 
    	'liker'  => __('Likes', 'wcs'),
    	'useful' => __('Useful', 'wcs')
    );
    
    $html .= '<h2 class="nav-tab-wrapper">';
    
    foreach($tabs as $tab => $name){
        $class = ($tab == $current) ? ' nav-tab-active' : '';
		
		$html .= '<a class="nav-tab' . $class . '" href="?page=' . WC_S_PLUGIN_PAGE_AD . '&tab=' . $tab . '">' . $name. '</a>';
    }
    
    $html .= '</h2>';
    
    echo $html;
}

function wc_s_settings_pages() {
	global $pagenow;
	
	$current = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'rating';
	
	if(isset($_POST['wcs-settings-submit'])){

		check_admin_referer('wcs-admin-settings-page');

		if($pagenow == WC_S_PLUGIN_URL_AD && $_GET['page'] == WC_S_PLUGIN_PAGE_AD){

			$wcsSettings = WCS_Config::wcs_get_settings();
			
			$keys = array_keys($wcsSettings[$current]);
			$keyPrefix = 'wcss-' . $current . '-';
			
			foreach($keys as $key){			
				$wcsSettings[$current][$key] = $_POST[$keyPrefix.$key];
			}
		}
		WCS_Config::wcs_set_settings($wcsSettings);	
	}
	
	if(isset($_POST['wcs-settings-reset'])){
		WCS_Config::wcs_set_default_settings(true);
	}
	
	$wcsSettings = WCS_Config::wcs_get_settings();

	wc_s_settings_tabs($current);	
	WCS_Config::wcs_print_styles();
	?>
	
	<div class="content-tab wcss-container">
	<form method="post" action="<?php admin_url(WC_S_PLUGIN_URL_AD . '?page=' . WC_S_PLUGIN_PAGE_AD); ?>">
	
	<?php
	wp_nonce_field('wcs-admin-settings-page');
 
	if($pagenow == WC_S_PLUGIN_URL_AD && $_GET['page'] == WC_S_PLUGIN_PAGE_AD){	

		$file = WC_S_PLUGIN_DIR . 'template/admin/settings.php';
		if(file_exists($file)){
			require_once($file);
		}	
	}
	?>
		<p>
			<input type="submit" name="wcs-settings-submit" class="button button-primary" value="<?php _e('Update settings', 'wcs', 'wcs') ?>" />
			<input type="submit" name="wcs-settings-reset" class="button button-default" value="<?php _e('Reset settings', 'wcs') ?>" />			
		</p>
	</form>
	</div>

<?php	
}