<?php
	
abstract class WCSociality {
	
	public $postID = 0;
	public $settings = array();
	
	protected $prefix = 'wcs__';	
	protected $cookieName = 'rating-post';
	protected $cookieTime = 315360000;	
	protected $disabled = false;
	
	public function __construct($postID = 0){
		global $post;
		
		$this->settings = WCS_Config::wcs_get_settings();
		$this->postID =	$postID ? $postID : $post->ID;		
	}
	
	
	
	public function wcs_is_disabled(){
		
		if(!empty($_COOKIE[$this->cookieName. '-' . $this->postID]))
			$this->disabled = true;
			
	    return $this->disabled;
    }
    
    
    
	public function wcs_save_cookie(){
	    setcookie($this->cookieName . '-' . $this->postID, 1, time() + $this->cookieTime, '/');
    }
    
    
    
    public function wcs_get_prefix(){
	    return $this->prefix;
    }
}