<?php
	
class WCS_Useful extends WCSociality {

	public $positive = 0;
	public $negative = 0;

	protected $cookieName = 'useful-post';
	protected $keys = array(
		'positive',
		'negative'
	);
	
	public function __construct($postID = 0){
		
		parent::__construct($postID);
		
		$this->settings = $this->settings['useful'];
			
		foreach($this->keys as $key){
			$this->$key = intval(get_post_meta($this->postID, $this->prefix . $key, true));
		}				
	}
	
	public function wcs_save($key){
		
		if(!in_array($key, $this->keys))
			return false;
		
	    $this->$key = $this->$key + 1;

		update_post_meta($this->postID, $this->prefix . $key, $this->$key);
	    
	    $this->wcs_save_cookie();
	}
}	