<?php 
	
class WCS_Rating extends WCSociality {

	public $rated = 0;
	public $voted = 0;
	public $score = 0;
	
	public $stars = 5;
	
	protected $keys = array(
		'rated',
		'voted',
		'score'
	);


	public function __construct($postID = 0){
		
		parent::__construct($postID);
		
		$this->settings = $this->settings['rating'];
		
		foreach($this->keys as $key){
			$this->$key = floatval(get_post_meta($this->postID, $this->prefix . $key, true));
		}
	}

	
	
	public function wcs_save($rated){
		
		$this->rated += intval($rated);
	    $this->voted += 1;
		
		$this->wcs_calculate();
		
		foreach($this->keys as $key){
			update_post_meta($this->postID, $this->prefix . $key, $this->$key);
		}

	    $this->wcs_save_cookie();
	}
	


    public function wcs_calculate(){
	    $this->score = round(intval($this->rated) / intval($this->voted), 1);
    }
}