<?php
	
abstract class WCS_Config {
	
	public static $settingsName = 'wcs__settings';
	
	private static $stylesIsPrinted = false;	
	private static $settings = array();
	private static $defaultSettings = array(
		'rating' => array(
			'color' 	 => '#e89b0f',
			'size'  	 => 24,
			'text'  	 => 'Рейтинг',
			'text-size'  => 16,
			'text-color' => '#444',
			'bg' 		 => '#fff',
			'border'  	 => '#fff',
		),
		'liker' => array(
			'color' 	 => '#fc5f5f',
			'size'  	 => 24,
			'text'  	 => 'Нравится!',
			'text-size'  => 16,
			'text-color' => '#444',
			'bg' 		 => '#fff',
			'border'  	 => '#fff',
		),
		'useful' => array(
			'color' 	 => array('#69d61b', '#fc2819'),
			'size'  	 => 24,
			'text'  	 => 'Была ли полезна эта статья?',
			'text-size'  => 16,
			'text-color' => '#444',
			'bg' 		 => '#fff',
			'border'  	 => '#fff',
		)
	);
	
	
		
	public static function wcs_set_settings($settings){
		if(!is_array($settings))
			return false;
		
		$settings = wp_parse_args($settings, self::$settings);		
		update_option(self::$settingsName, $settings);
	}
	
	
	public static function wcs_get_settings($name = null){
		self::$settings = get_option(self::$settingsName);
		
		if($name && isset(self::$settings[$name]))
			return self::$settings[$name];
		
		return self::$settings;
	}
	
	
	public static function wcs_set_default_settings($strict = false){
		if($strict)
			update_option(self::$settingsName, self::$defaultSettings);			
		else
			add_option(self::$settingsName, self::$defaultSettings);
	}
	
	
	public static function wcs_get_default_settings($name = null){
		
		if($name && isset(self::$defaultSettings[$name]))
			return self::$defaultSettings[$name];
		
		return self::$defaultSettings;
	}
	
	
	public static function wcs_print_styles(){
		
		if(self::$stylesIsPrinted)
			return false;
		
		$style = '<style>';
		
		$style .= '
			.wcs-rating {
				background-color: ' . self::$settings['rating']['bg'] . ';
				border: 1px solid ' . self::$settings['rating']['border'] . ';
			}
			.wcs-liker {
				background-color: ' . self::$settings['liker']['bg'] . ';
				border: 1px solid ' . self::$settings['liker']['border'] . ';
			}
			.wcs-useful {
				background-color: ' . self::$settings['useful']['bg'] . ';
				border: 1px solid ' . self::$settings['useful']['border'] . ';
				font-size: ' . self::$settings['liker']['text-size'] . 'px;
				color: ' . self::$settings['liker']['text-color'] . ';
			}
			.wcs-star {
				font-size: ' . self::$settings['rating']['size'] . 'px;
				color: ' . self::$settings['rating']['color'] . ';
			}
			.wcs-rating-text,
			.wcs-rating-after {
				font-size: ' . self::$settings['rating']['text-size'] . 'px;
				color: ' . self::$settings['rating']['text-color'] . ';
			}
			.wcs-like {
				font-size: ' . self::$settings['liker']['size'] . 'px;
				color: ' . self::$settings['liker']['color'] . ';
			}
			.wcs-liker-text,
			.wcs-liker-count {
				font-size: ' . self::$settings['liker']['text-size'] . 'px;
				color: ' . self::$settings['liker']['text-color'] . ';
			}			
			.wcs-positive {
				font-size: ' . self::$settings['useful']['size'] . 'px;
				color: ' . self::$settings['useful']['color'][0] . ';
			}
			.wcs-negative {
				font-size: ' . self::$settings['useful']['size'] . 'px;
				color: ' . self::$settings['useful']['color'][1] . ';
			}
			.wcs-useful-text {
				font-size: ' . self::$settings['useful']['text-size'] . 'px;
				color: ' . self::$settings['useful']['text-color'] . ';
			}
			.wcs-useful.disabled .wcs-positive-count {
				color: ' . self::$settings['useful']['color'][0] . '; 
			}
			.wcs-useful.disabled .wcs-negative-count {
				color: ' . self::$settings['useful']['color'][1] . ';
			}
			';
		
		$style .= '</style>';
		echo $style;
		
		self::$stylesIsPrinted = true;	
	}
}	