<?php if(!defined('ABSPATH')) exit; ?>
<div class="wrap">
    <?php require "header.php" ?>
    <div class="wcc-card wcc-mt-15">
        <h2 class="wcc-card-title"><?php esc_html_e( 'Notion CRM Configuration', 'wcc-cf7-to-notion' ); ?></h2>
        <form method="post">
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="name" title="<?php esc_html_e( 'Name', 'wcc-cf7-to-notion' ); ?>" ><?php esc_html_e( 'Name (required)', 'wcc-cf7-to-notion' ); ?></label></th>
                        <td>
                            <input class="wcc-input" type="text" name="name" placeholder="Name" id="name" required="required" value="<?php echo (isset($info['name']) ? esc_attr($info['name']) : ""); ?>" />
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="wcc_cf7_notion_access_token" title="<?php esc_html_e( 'Access Token (required)', 'wcc-cf7-to-notion' ); ?>" ><?php esc_html_e( 'Access Token (required)', 'wcc-cf7-to-notion' ); ?></label></th>
                        <td>
                            <input class="wcc-input" type="text" name="wcc_cf7_notion_access_token" placeholder="Access Token" id="wcc_cf7_notion_access_token" required="required" value="<?php echo (isset($info['access_token']) ? esc_attr($info['access_token']) : ""); ?>" />
                        </td>
                    </tr>
                </tbody>
            </table>
            <p>
                <input type="hidden" name="edit_id" id="edit_id" value="<?php echo (isset($info['id']) ? esc_attr($info['id']) : ""); ?>" />
                <input type="hidden" name="_wpnonce" value="<?php echo esc_attr(wp_create_nonce( 'wcc_cf7_notion_configuration' )) ?>">
                <input type='submit' class='button button-primary' name="wcc_cf7_notion_config_btn" value="<?php if(isset($info['id'])){ echo esc_attr__("Update", 'wcc-cf7-to-notion'); } else { echo esc_attr__("Add", 'wcc-cf7-to-notion'); } ?>"  title="<?php if(isset($info['id'])){ echo esc_attr__("Update", 'wcc-cf7-to-notion'); } else { echo esc_attr__("Add", 'wcc-cf7-to-notion'); } ?>" />
                <a href="<?php echo esc_url(menu_page_url( 'wcc-cf7-to-notion', 0 )); ?>&tab=configuration" class="button wcc-my-btn-danger" title="Cancel">Cancel</a>
            </p>
        </form>
    </div>
    <?php require "message.php" ?>
</div>