<?php if(!defined('ABSPATH')) exit; ?>
<div class="wrap">
    <?php require "header.php" ?>
    <h1 class="wp-heading-inline">Notion Accounts</h1>
    <a title="Add New Account" class="page-title-action" href="<?php echo esc_url(menu_page_url( 'wcc-cf7-to-notion', 0 )); ?>&tab=configuration&add=1">Add New Account</a>
    <div class="wcc-mt-15 wcc-p-0">
        <table class="wcc-table-js widefat wcc_data_table mt-0 wcc-table wcc-config-table">
            <thead>
                <tr>
                    <td >Name</td>
                    <td style="width:35%">Credentials</td>
                    <td>Date Added</td>
                    <td>Date Updated</td>
                    <td class="wcc-text-right">Action</td>
                </tr>
            </thead>
            <tbody>
                <?php if($accounts) { ?>
                    <?php foreach ($accounts as $key => $value) { ?>
                        <tr>
                            <td>
                                <?php echo esc_html($value['name']) ?>
                            </td>
                            <td>
                                Access Token : <?php echo ($value['access_token'] ? esc_html($value['access_token']) : "N/A") ?>
                            </td>
                            <td><?php echo esc_html($value['date_added']) ?></td>
                            <td><?php echo esc_html($value['date_updated']) ?></td>
                            <td class="wcc-text-right">
                                <a href="<?php echo esc_url(menu_page_url( 'wcc-cf7-to-notion', 0 )); ?>&tab=configuration&add=1&id=<?php echo esc_html($value['id']) ?>" title="Edit">Edit</a> | 
                                <a class="wcc-text-danger" onclick="if(!confirm('Sure you want to delete account?')){return false;}" href="<?php echo esc_url(menu_page_url( 'wcc-cf7-to-notion', 0 )); ?>&tab=configuration&_wpnonce=<?php echo esc_html($nonce) ?>&wcc_cf7_notion_configuration_delete=<?php echo esc_html($value['id']) ?>" title="Delete">Delete</a>
                            </td>
                        </tr>
                    <?php } ?>
                <?php }else{ ?>
                    <tr>
                        <td colspan="5" class="wcc-text-center">Record not found</td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
    <?php require "message.php" ?>
</div>