<?php
if (!defined('ABSPATH')) exit;
/**
 * @package WccCf7Notion
 */

/**
 * Class WccCf7Notion_Forms.
 *
 * @since 1.0.0
 */
class WccCf7Notion_Forms {


    var $authorization_code;
    
    function __construct($array = array()) {
        
        if(!empty($array['authorization_code'])){
            $this->authorization_code = $array['authorization_code'];
        }
    }



    /**
     * Forms.
     *
     * @since 1.0.0
     * @access public
     */
    public function list() {
        global $wpdb;
        $forms = array();

        $cf7_db_version = get_option( 'cf7_db_version' );


        if ( $cf7_db_version && version_compare( $cf7_db_version, '2.3', '>=' ) ) {
            $table_name = $wpdb->prefix."cf7_form";
            $forms = $wpdb->get_results( $wpdb->prepare('SELECT * FROM {$table_name} WHERE is_trash=%d',0) );
        } else {
            $table_name = $wpdb->prefix."rg_form";
            $forms = $wpdb->get_results( $wpdb->prepare('SELECT * FROM {$table_name} WHERE is_trash=%d',0) );
        }
        return $forms;
    }

    public function info( $id ) {
        global $wpdb;

        $cf7_db_version = get_option( 'cf7_db_version' );
        if ( $cf7_db_version && version_compare( $cf7_db_version, '2.3', '>=' ) ) {
            $table_name = $wpdb->prefix.'cf7_form_meta';
            $form_meta = $wpdb->get_row( $wpdb->prepare('SELECT * FROM {$table_name} WHERE form_id=%d LIMIT 1',$id) );
        } else {
            $table_name = $wpdb->prefix.'rg_form_meta';
            $form_meta = $wpdb->get_row( $wpdb->prepare('SELECT * FROM {$table_name} WHERE form_id=%d LIMIT 1',$id) );
        }
        return $form_meta;
    }

    public function getModuleFields( $database_id = "" ) {
        
        $fields = array();


        $token = $this->access_token;

        $header = array(
            'Authorization' => 'Bearer '.$token,
            'Content-Type' => 'application/json',
            'Notion-Version' => '2022-06-28',
        );
        $url = WccCf7Notion::$apiUrl."/databases/".$database_id;
        $response = wp_remote_get($url,array(
            "headers" => $header
        ));
        $response     = json_decode( wp_remote_retrieve_body( $response ),1);

        $lists = array();
        if(!empty($response['properties'])){
            foreach ($response['properties'] as $key => $value) {
                $fields[$value['name']] = array(
                    'label'     => $value['name'],
                    'type'      => $value['type'],  
                    'required'  => 0,
                    'choices'   => isset($value['multi_select']['options']) ? $value['multi_select']['options'] : array(),
                );
            }
        }
          
        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wcc_cf7_notion_notification_send_to' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wcc_cf7_notion_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            $wcc_cf7_notion_debug = get_option("wcc_cf7_notion_debug");
            $wcc_cf7_notion_debug .= $log."\n\n";
            update_option("wcc_cf7_notion_debug",$wcc_cf7_notion_debug);
        }

        
        return $fields;
    }
    
    function addRecord( $module, $data_send, $form_id ,$connector_fields) {
        
        $token = $this->accesstoken;
        
        $data = array();
        $data_manage = $data_send;

        

        $data["parent"]['database_id'] = $this->database_id;
        $data["properties"] = array();

        foreach ($data_send as $key => $value) {
            if(isset($connector_fields[$key])){
                switch ($connector_fields[$key]['type']) {
                    case 'checkbox':
                        $data["properties"][$key] = array(
                            "checkbox" => $value
                        );
                        break;
                    case 'created_by':
                        $data["properties"]["created_by"] = array(
                            "object" => "user",
                            "id" => $value
                        );
                        break;
                    case 'created_time':
                        break;
                    case 'date':
                        $data["properties"][$key] = array(
                            "date" => array(
                                "start" => $value,
                            )
                        );
                        break;
                    case 'email':
                        $data["properties"][$key] = array(
                            "email" => $value,
                        );
                        break;
                    case 'files':
                        $data["properties"][$key] = array(
                            "files" => array(
                                array(
                                    "name" => $value,
                                    "external" => array(
                                        "url" => $value
                                    ),
                                )
                            )
                        );
                        break;
                    case 'formula':
                        break;
                    case 'last_edited_by':
                        break;
                    case 'last_edited_time':
                        break;
                    case 'multi_select':
                        $data["properties"][$key] = array(
                            "multi_select" => array(
                                array(
                                    "name" => $value
                                )
                            ),
                        );
                        break;
                    case 'number':
                        $data["properties"][$key] = array(
                            "number" => $value
                        );
                        break;
                    case 'people':
                        $data["properties"][$key] = array(
                            "people" => array(
                                array(
                                    "object" => "user",
                                    "id" => $value
                                )
                            ),
                        );
                        break;
                    case 'phone_number':
                        $data["properties"][$key] = array(
                            "phone_number"=> $value
                        );
                        break;
                    case 'relation':
                        $data["properties"][$key] = array(
                            "relation" => array(
                                array(
                                    "id" => $value
                                )
                            )
                        );
                        break;
                    case 'rollup':

                        break;
                    case 'rich_text':
                        $data["properties"][$key] = array(
                            "rich_text" => array(
                                array(
                                    "type" => "text",
                                    "text"=> array(
                                        "content"=> $value,
                                        "link"=> null
                                    ),
                                    "plain_text"=> $value,
                                ),
                            ),
                        );
                        break;
                    case 'select':
                        $data["properties"][$key] = array(
                            "select" => array(
                                "name" => $value
                            ),
                        );
                        break;
                    case 'status':
                        $data["properties"][$key] = array(
                            "status" => array(
                                "name" => $value
                            ),
                        );
                        break;
                    case 'title':
                        $data["properties"][$key] = array(
                            "title" => array(
                                array(
                                    "type" => "text",
                                    "text"=> array(
                                        "content"=> $value,
                                        "link"=> null
                                    ),
                                    "plain_text"=> $value,
                                ),
                            ),
                        );
                        break;
                    case 'url':
                        $data["properties"][$key] = array(
                            "url" => $value
                        );
                        break;
                }
            }
        }

        $data_post = $data;
        $header = array(
            'Authorization' => 'Bearer '.$token,
            'Content-Type' => 'application/json',
            'Notion-Version' => '2022-06-28',
        );
        
        $url = WccCf7Notion::$apiUrl."/pages";

        $data = wp_json_encode($data_post);

        $main_response = wp_remote_post($url,
            array(
                'headers' => $header,
                "body"  => $data
            )
        );

        $json_response = wp_remote_retrieve_body($main_response);

        $response = json_decode($json_response,1);

        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wcc_cf7_notion_notification_send_to' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wcc_cf7_notion_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            $wcc_cf7_notion_debug = get_option("wcc_cf7_notion_debug");
            $wcc_cf7_notion_debug .= $log."\n\n";
            update_option("wcc_cf7_notion_debug",$wcc_cf7_notion_debug);
        }
        
        return $response;
    }
    
    
    function getDatabase(){
        
        $token = $this->accesstoken;
        
        $header = array(
            'Authorization' => 'Bearer '.$token,
            'Content-Type' => 'application/json',
            'Notion-Version' => '2022-06-28',
        );
        
        $url = WccCf7Notion::$apiUrl."/search";

        $data = array(
            "filter" => array(
                "value" => "database",
                "property" => "object",
            ),
        );

        $main_response = wp_remote_post($url,
            array(
                "body" => wp_json_encode($data),
                'headers' => $header,
            )
        );

        $json_response = wp_remote_retrieve_body($main_response);
        $response = json_decode($json_response,1);
        return !empty($response['results']) ? $response['results'] : array();
    }
    
    
    function addFile( $data, $form_id ) {
     
        $header = array(
            'Authorization' => 'Token token='.$this->key,
            'Content-Type' => 'multipart/form-data',
            'content-type' => 'multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW',
        );


        
        if ( strpos( $this->url, 'freshsales.io' ) !== false ) {
            $url = $this->url.'/api/documents';
        } else {
            $url = $this->url.'/crm/sales/api/documents';
        }
       
        $data = wp_json_encode($data);

        $main_response = wp_remote_post($url,
            array(
                'headers' => $header,
                "body"  => $data
            )
        );


        $json_response = wp_remote_retrieve_body($main_response);
        $response = json_decode($json_response,1);

         
        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wcc_cf7_notion_notification_send_to	' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wcc_cf7_notion_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            $wcc_cf7_notion_debug = get_option("wcc_cf7_notion_debug");
            $wcc_cf7_notion_debug .= $log."\n\n";
            update_option("wcc_cf7_notion_debug",$wcc_cf7_notion_debug);
        }
        
        
        return $response;
    }
}