<?php
/*
 * Plugin Name: WCC CF7 to Getjobber
 * Description: Send Your Contact Form 7 Entries to Your Getjobber Account With Ease.
 * Requires Plugins: contact-form-7
 * Author: WeConnectCode
 * Author URI: https://weconnectcode.com/
 *
 * Text Domain: wcc-cf7-to-getjobber
 * Domain Path: languages
 * Version: 1.0.0
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
define("WCCC_CF7_GETJOBBER_PLUGIN_PATH", plugin_dir_path( __FILE__ )."/");
if ( file_exists( plugin_dir_path( __FILE__ ) . '/autoload.php' ) ) {
    require_once plugin_dir_path( __FILE__ ) . '/autoload.php';
}

if ( ! class_exists( 'WccCf7Getjobber' ) ) {


    /**
     * Class WccCf7Getjobber.
     *
     * @since 1.0.0
     */
    class WccCf7Getjobber {

        /**
         * Plugin basename.
         *
         * @var string plugin basename
         *
         * @since 1.0.0
         * @access public
         */
        public $plugin;

        public static $modules = array(
            "clients" => "Clients" ,
        );
        public static $module = "clients";

        public static $pages = array(
            "wcc_cf7_getjobber" ,
        );
        /**
         * Plugin version.
         *
         * @var string plugin version
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $wcc_cf7_getjobber_version = '1.0.0';


        /**
         * Plugin name.
         *
         * @var string plugin name
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $plugin_name = 'CF7 – Getjobber';

        /**
         * Plugin site.
         *
         * @var string plugin site
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $plugin_site = 'https:://test.com';
        public static $plugin_url = 'https://www.weconnectcode.com/plugin/getjobber-for-contact-form-7';

        /**
         * Plugin domain.
         *
         * @var string plugin domain
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $domain = 'wcc-cf7-to-getjobber';

        /**
         * Plugin prefix.
         *
         * @var string plugin prefix
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $prefix = 'wcc_cf7_getjobber_';


        /**
         * Shortcode name.
         *
         * @var string shortcode name
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $shortcode_widget = 'wcc_cf7_getjobber_shortcode';

        /**
         * Page for iframe embed.
         *
         * @var string page name
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $page_title = 'Getjobber CRM Integration';

        /**
         * Page slug for iframe embed.
         *
         * @var string page slug
         *
         * @since 1.0.0
         * @access public
         * @static
         */
        public static $page_name = 'wcc_cf7_getjobber_settings';

   
        public static $authurl = 'https://api.getjobber.com/api/oauth/authorize';
        public static $authTokenUrl = 'https://api.getjobber.com/api/oauth/token';
        public static $apiUrl = 'https://api.getjobber.com/api/graphql';

        public static $wcc_cf7_getjobber_api_version = '4.0.9';
        /**
         * WccCf7Getjobber constructor.
         *
         * @since 1.0.0
         * @access public
         */
        public function __construct() {
            $this->plugin = plugin_basename( __FILE__ );
        }

        /**
         * Register Platform functions.
         *
         * @since 1.0.0
         * @access public
         */
        public function register() {
            load_plugin_textdomain( self::$domain, false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
        }


        public function uninstall() {
            $uninstall = get_option( 'wcc_cf7_getjobber_uninstall' );
            if ( $uninstall ) {
                delete_option( 'wcc_cf7_getjobber_notification_subject' );
                delete_option( 'wcc_cf7_getjobber_notification_send_to	' );
                delete_option( 'wcc_cf7_getjobber_ignore_spam_entry' );
                delete_option( 'wcc_cf7_getjobber_uninstall' );

                global $wpdb;

                $table_name = esc_sql($wpdb->prefix . 'wcc_cf7_getjobber_accounts');
                
                $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS $table_name"));

                $table_name = esc_sql($wpdb->prefix . 'wcc_cf7_getjobber_feeds');
                
                $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS $table_name"));

                $table_name = esc_sql($wpdb->prefix . 'wcc_cf7_getjobber_feeds_to_field');
                
                $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS $table_name"));

                $table_name = esc_sql($wpdb->prefix . 'wcc_cf7_getjobber_feeds_to_history');
                
                $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS $table_name"));
            }
        }
        /**
         * Activate plugin.
         *
         * @since 1.0.0
         * @access public
         */
        public function activate() {
            global $wpdb;
            global $wcc_cf7_getjobber_db_version;

            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

            $table_name = $wpdb->prefix . 'wcc_cf7_getjobber_accounts';  
            $charset_collate = $wpdb->get_charset_collate();
            $sql = "CREATE TABLE IF NOT EXISTS $table_name (
                id          mediumint(9) NOT NULL AUTO_INCREMENT, 
                name     text NOT NULL, 
                client_id     text NOT NULL, 
                client_secret     text NOT NULL,
                authorization_code     text NOT NULL,
                date_added        datetime DEFAULT '0000-00-00 00:00:00' NOT NULL, 
                date_updated        datetime DEFAULT '0000-00-00 00:00:00' NOT NULL, 
                PRIMARY KEY  (id)
            ) $charset_collate;";
            dbDelta( $sql );



            $table_name = $wpdb->prefix . 'wcc_cf7_getjobber_feeds';  
            $charset_collate = $wpdb->get_charset_collate();
            $sql = "CREATE TABLE IF NOT EXISTS $table_name (
                id          mediumint(9) NOT NULL AUTO_INCREMENT, 
                account_id     int(11) NOT NULL,
                form_id     varchar(200) NOT NULL,
                name     text NOT NULL, 
                action     text NOT NULL, 
                module     text NOT NULL, 
                status     int(11) NOT NULL,
                date_added        datetime DEFAULT '0000-00-00 00:00:00' NOT NULL, 
                date_updated        datetime DEFAULT '0000-00-00 00:00:00' NOT NULL, 
                PRIMARY KEY  (id)
            ) $charset_collate;";
            dbDelta( $sql );




            $table_name = $wpdb->prefix . 'wcc_cf7_getjobber_feeds_to_field';  
            $charset_collate = $wpdb->get_charset_collate();
            $sql = "CREATE TABLE IF NOT EXISTS $table_name (
                id          mediumint(9) NOT NULL AUTO_INCREMENT, 
                feed_id     int(11) NOT NULL,
                crm_field     text NOT NULL, 
                fields_type     text NOT NULL, 
                value     text NOT NULL, 
                PRIMARY KEY  (id)
            ) $charset_collate;";
            dbDelta( $sql );



            $table_name = $wpdb->prefix . 'wcc_cf7_getjobber_feeds_to_history';  
            $charset_collate = $wpdb->get_charset_collate();
            $sql = "CREATE TABLE IF NOT EXISTS $table_name (
                id          mediumint(9) NOT NULL AUTO_INCREMENT, 
                feed_id     int(11) NOT NULL,
                entry_id     int(11) NOT NULL,
                connector_entry_id     text NOT NULL,
                data_sent     text NOT NULL, 
                response     text NOT NULL, 
                trigger_type     text NOT NULL, 
                object     text NOT NULL,
                status     int(11) NOT NULL,
                note     text NOT NULL,
                date_added        datetime DEFAULT '0000-00-00 00:00:00' NOT NULL, 
                date_updated        datetime DEFAULT '0000-00-00 00:00:00' NOT NULL, 
                PRIMARY KEY  (id)
            ) $charset_collate;";
            dbDelta( $sql );
            
            add_option( 'wcc_cf7_getjobber_db_version', $wcc_cf7_getjobber_db_version );
            flush_rewrite_rules();

            register_uninstall_hook( __FILE__, array($this,'uninstall') );
        }

        /**
         * Deactivate plugin.
         *
         * @since 1.0.0
         * @access public
         */

        /**
         * Debug function.
         *
         * @param string|array|bool|mixed $data data for debugging
         * @param bool $die die or not
         * @param bool $print 'print' or 'var_dump'
         *
         * @since 1.0.0
         * @access public
         * @ignore
         */
        public static function debug( $data, $die = true, $print = true ) {
            if ( $print ) {
                echo '<pre>';
                print_r( esc_html($data) );
                echo '</pre>';
            } else {
                var_dump( $data );
            }

            if ( $die ) {
                wp_die();
            }
        }


    }

    $platform = new WccCf7Getjobber();
    $platform->register();


    $actions = new WccCf7Getjobber_Actions();
    /**
     * Activate plugin.
     */
    register_activation_hook( __FILE__, array( $platform, 'activate' ) );
}
