<?php if(!defined('ABSPATH')) exit; ?>
<div class="wrap">
    <?php require "header.php" ?>
    <?php if (!empty($_POST['nonce']) && wp_verify_nonce( sanitize_text_field(wp_unslash($_POST['nonce'])), WccCf7Getjobber::$prefix.'setting' ) && isset( $_POST['submit'] ) ) { ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e( 'Settings saved.', 'wcc-cf7-to-getjobber' ); ?></p>
        </div>
    <?php } ?>
    <h1 class="wp-heading-inline"><?php esc_html_e( 'Settings', 'wcc-cf7-to-getjobber' ); ?></h1>
    <div class="wcc-card wcc-mt-15">
        <form method="post">
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="wcc_cf7_getjobber_notification_subject" title="<?php esc_html_e( 'API Error Notification', 'wcc-cf7-to-getjobber' ); ?>" ><?php esc_html_e( 'API Error Notification', 'wcc-cf7-to-getjobber' ); ?></label></th>
                        <td>
                            <label for="wcc_cf7_getjobber_notification_subject" title="<?php esc_html_e( 'Subject', 'wcc-cf7-to-getjobber' ); ?>"><?php esc_html_e( 'Subject', 'wcc-cf7-to-getjobber' ); ?></label><br>
                            <input class="wcc-input" type="text" name="wcc_cf7_getjobber_notification_subject" id="wcc_cf7_getjobber_notification_subject" value="<?php echo esc_attr($notification_subject); ?>" />
                            <p class="description"><?php esc_html_e( 'Enter The Subject.', 'wcc-cf7-to-getjobber' ); ?></p><br><br>
                            <label for="wcc_cf7_getjobber_notification_send_to	" title="<?php esc_html_e( 'Send To', 'wcc-cf7-to-getjobber' ); ?>"><?php esc_html_e( 'Send To', 'wcc-cf7-to-getjobber' ); ?></label><br>
                            <input class="wcc-input" type="text" name="wcc_cf7_getjobber_notification_send_to	" id="wcc_cf7_getjobber_notification_send_to	" value="<?php echo esc_attr($notification_send_to); ?>" />
                            <p class="description"><?php esc_html_e( 'Enter the email address. For multiple email addresses, you can add email address by comma separated.', 'wcc-cf7-to-getjobber' ); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="wcc-switch" title="<?php esc_html_e( 'Ignore Spam Entry?', 'wcc-cf7-to-getjobber' ); ?>"><?php esc_html_e( 'Ignore Spam Entry?', 'wcc-cf7-to-getjobber' ); ?></label></th>
                        <td>
                            <input type="hidden" name="wcc_cf7_getjobber_ignore_spam_entry" value="0" />
                            <div class="switch-wrapper switch-display-options">
                                <div  class="wcc-switch-control">
                                    <input  id="wcc-switch" value="1"  type="checkbox" name="wcc_cf7_getjobber_ignore_spam_entry" class="wcc-switch" <?php echo ( $ignore_spam_entry ? esc_attr(' checked') : '' ); ?>>
                                    <label  for="wcc-switch" class="blue">
                                    </label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="wcc-uninstall" title="<?php esc_html_e( 'Delete Data On Uninstall?', 'wcc-cf7-to-getjobber' ); ?>"><?php esc_html_e( 'Delete Data On Uninstall?', 'wcc-cf7-to-getjobber' ); ?></label></th>
                        <td>
                            <input type="hidden" name="wcc_cf7_getjobber_uninstall"  value="0" />

                            <div class="switch-wrapper switch-display-options">
                                <div  class="wcc-switch-control">
                                    <input  id="wcc-uninstall" value="1"  type="checkbox" name="wcc_cf7_getjobber_uninstall" class="wcc-switch" <?php echo ( $uninstall ? esc_attr(' checked') : '' ); ?>>
                                    <label  for="wcc-uninstall" class="blue">
                                    </label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label title="<?php esc_html_e( 'Redirect URL', 'wcc-cf7-to-getjobber' ); ?>"><?php esc_html_e( 'Redirect URL', 'wcc-cf7-to-getjobber' ); ?></label></th>
                        <td>
                            <?php echo esc_url($redirect_url) ?>
                        </td>
                    </tr>
                </tbody>
            </table>
            <p>
                <input type="hidden" name="nonce" value="<?php echo esc_attr(wp_create_nonce(WccCf7Getjobber::$prefix.'setting')); ?>">
                <input type='submit' class='button button-primary' name="submit" value="<?php esc_html_e( 'Save Changes', 'wcc-cf7-to-getjobber' ); ?>" title="<?php esc_html_e( 'Save Changes', 'wcc-cf7-to-getjobber' ); ?>" />
            </p>
        </form>
    </div>
    <?php require "message.php" ?>
</div>