<?php
if (!defined('ABSPATH')) exit;
/**
 * @package WccCf7Getjobber
 */

/**
 * Class WccCf7Getjobber_Forms.
 *
 * @since 1.0.0
 */
class WccCf7Getjobber_Forms {



    var $authtoken;

    var $accesstoken;
    var $id;
    var $authorization_code;
    var $client_id;
    var $client_secret;
    
    function __construct($array = array()) {
         
        if(!empty($array['id'])){
            $this->id = $array['id'];
        }
        if(!empty($array['authorization_code'])){
            $this->authorization_code = $array['authorization_code'];
        }
        if(!empty($array['client_id'])){
            $this->client_id = $array['client_id'];
        }
        if(!empty($array['client_secret'])){
            $this->client_secret = $array['client_secret'];
        }
        $this->accesstoken();
        
    }

    public function accesstoken() {

        $post = array(
            "client_id" => $this->client_id,
            "client_secret" => $this->client_secret,
            "grant_type" => "refresh_token",
            "refresh_token" => $this->authorization_code,
        );
        $reposnse = wp_remote_post(WccCf7Getjobber::$authTokenUrl,array(
                'headers' => array(
                    "Content-Type" => "application/x-www-form-urlencoded"
                ),
                "body"  => $post
            )
        );
        $reposnse     = json_decode( wp_remote_retrieve_body( $reposnse ),1);


        $token = "";

        if(!empty($reposnse['access_token'])){
            $token = $reposnse['access_token'];
        }

        global $wpdb;
        $table_name = $wpdb->prefix . 'wcc_cf7_getjobber_accounts';  
        if(!empty($reposnse['refresh_token'])){
            $wpdb->update($table_name,array("authorization_code" => $reposnse['refresh_token']),array("id" => $this->id));
        }

        $this->accesstoken = $token;
        return $token;
    }


    /**
     * Forms.
     *
     * @since 1.0.0
     * @access public
     */
    public function list() {
        global $wpdb;
        $forms = array();

        $cf7_db_version = get_option( 'cf7_db_version' );


        if ( $cf7_db_version && version_compare( $cf7_db_version, '2.3', '>=' ) ) {
            $table_name = $wpdb->prefix."gf_form";
            $forms = $wpdb->get_results( $wpdb->prepare('SELECT * FROM {$table_name} WHERE is_trash=%d',0) );
        } else {
            $table_name = $wpdb->prefix."rg_form";
            $forms = $wpdb->get_results( $wpdb->prepare('SELECT * FROM {$table_name} WHERE is_trash=%d',0) );
        }
        return $forms;
    }

    public function info( $id ) {
        global $wpdb;

        $cf7_db_version = get_option( 'cf7_db_version' );
        if ( $cf7_db_version && version_compare( $cf7_db_version, '2.3', '>=' ) ) {
            $table_name = $wpdb->prefix.'gf_form_meta';
            $form_meta = $wpdb->get_row( $wpdb->prepare('SELECT * FROM {$table_name} WHERE form_id=%d LIMIT 1',$id) );
        } else {
            $table_name = $wpdb->prefix.'rg_form_meta';
            $form_meta = $wpdb->get_row( $wpdb->prepare('SELECT * FROM {$table_name} WHERE form_id=%d LIMIT 1',$id) );
        }
        return $form_meta;
    }
    public function getModuleFields( $module = "" ) {
        if(!$module){
            $module = WccCf7Getjobber::$module;
        }

        $fields = array();

        if($module == "clients" || $module == "requests"){

            
            $fields["companyName"] = array(
                'label'     => "Company Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );
            

            $fields["firstName"] = array(
                'label'     => "First Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );


            $fields["isArchivable"] = array(
                'label'     => "IS Archivable",
                'type'      => "Choice",  
                'required'  => 0,
                'choices'   => array(
                    array(
                        "id" => "True",
                        "option" => "true",
                    ),
                    array(
                        "id" => "False",
                        "option" => "false",
                    ),
                ),
            );

            
            $fields["isArchived"] = array(
                'label'     => "IS Archived",
                'type'      => "Choice",  
                'required'  => 0,
                'choices'   => array(
                    array(
                        "id" => "True",
                        "option" => "true",
                    ),
                    array(
                        "id" => "False",
                        "option" => "false",
                    ),
                ),
            );
            
            $fields["isCompany"] = array(
                'label'     => "IS Company",
                'type'      => "Choice",  
                'required'  => 0,
                'choices'   => array(
                    array(
                        "id" => "True",
                        "option" => "true",
                    ),
                    array(
                        "id" => "False",
                        "option" => "false",
                    ),
                ),
            );
            
            $fields["isLead"] = array(
                'label'     => "IS Lead",
                'type'      => "Choice",  
                'required'  => 0,
                'choices'   => array(
                    array(
                        "id" => "True",
                        "option" => "true",
                    ),
                    array(
                        "id" => "False",
                        "option" => "false",
                    ),
                ),
            );
            $fields["jobberWebUri"] = array(
                'label'     => "Jobber Web URI",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["lastName"] = array(
                'label'     => "Last Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["name"] = array(
                'label'     => "Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );


            $fields["secondaryName"] = array(
                'label'     => "Secondary Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["title"] = array(
                'label'     => "Title",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

        }

        if($module == "requests"){

            $fields["request_title"] = array(
                'label'     => "Request Title",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );
        }
        return $fields;
    }
    
    function addRecord( $module, $data, $form_id ) {

        $token = $this->accesstoken;
        if(!$this->accesstoken){
            $token = $this->accesstoken();
        }
        
        if ( $module == 'leads' ) {
            $data = array(
                'lead'  => $data_send,
            );
        } else if ( $module == 'notes' ) {
            $data = array(
                'note'  => $data_send,
            );
        } else {

            $data_manage = $data_send;

            $data = array();
            
            if(isset($data_send['companyName'])){
                $data[] = 'companyName:\"'.addslashes($data_send['companyName']).'\"' ;
                unset($data_manage['companyName']);
            }            
            if(isset($data_send['emails'])){
                $data[] = 'emails:[{description: MAIN, primary: true, address: \"'.addslashes($data_send['emails']).'\"}]';
                unset($data_manage['emails']);
            }            
            if(isset($data_send['firstName'])){
                $data[] = 'firstName:\"'.addslashes($data_send['firstName']).'\"' ;
                unset($data_manage['firstName']);
            }            
            if(isset($data_send['isArchivable'])){
                $data[] = 'isArchivable:'.(bool)$data_send['isArchivable'] ;
                unset($data_manage['isArchivable']);
            }            
            if(isset($data_send['isArchived'])){
                $data[] = 'isArchived:'.(bool)$data_send['isArchived'] ;
                unset($data_manage['isArchived']);
            }            
            if(isset($data_send['isCompany'])){
                $data[] = 'isCompany:'.(bool)$data_send['isCompany'] ;
                unset($data_manage['isCompany']);
            }            
            if(isset($data_send['isLead'])){
                $data[] = 'isLead:'.(bool)$data_send['isLead'] ;
                unset($data_manage['isLead']);
            }            
            if(isset($data_send['jobberWebUri'])){
                $data[] = 'jobberWebUri:\"'.addslashes($data_send['jobberWebUri']).'\"' ;
                unset($data_manage['jobberWebUri']);
            }            
            if(isset($data_send['lastName'])){
                $data[] = 'lastName:\"'.addslashes($data_send['lastName']).'\"' ;
                unset($data_manage['lastName']);
            }            
            if(isset($data_send['name'])){
                $data[] = 'name:\"'.addslashes($data_send['name']).'\"' ;
                unset($data_manage['name']);
            }            

            if(isset($data_send['secondaryName'])){
                $data[] = 'secondaryName:\"'.addslashes($data_send['secondaryName']).'\"' ;
                unset($data_manage['secondaryName']);
            }            
            if(isset($data_send['title'])){
                $data[] = 'title:\"'.addslashes($data_send['title']).'\"' ;
                unset($data_manage['title']);
            }
        
        }

        $header = array(
            'X-JOBBER-GRAPHQL-VERSION' => '2024-06-10',
            'Authorization' => 'Bearer '.$token,
            'Content-Type' => 'application/json',
        );
        
        $url = WccCf7Getjobber::$apiUrl;

        $body = '{
         "query": "mutation SampleMutation {    clientCreate(      input: {'.implode(",", $data).'}  ) {    client {      id      firstName      lastName    }    userErrors {      message      path    }  } }",
         "operationName": "SampleMutation"
        }';

        $main_response = wp_remote_post($url,
            array(
                'headers' => $header,
                'body' => $body,
            )
        );

        $json_response = wp_remote_retrieve_body($main_response);
        
        $response = json_decode($json_response,1);

         
        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wcc_cf7_getjobber_notification_send_to	' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wcc_cf7_getjobber_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            
            $wcc_cf7_getjobber_debug = get_option("wcc_cf7_getjobber_debug");
            $wcc_cf7_getjobber_debug .= $log."\n\n";
            update_option("wcc_cf7_getjobber_debug",$wcc_cf7_getjobber_debug);
        }


        if ( $module == 'requests' ) {

            if ( isset( $response['data']['clientCreate']['client']['id'] ) ) {
                $data = array();
                
                $data[] = 'clientId:\"'.addslashes($response['data']['clientCreate']['client']['id']).'\"' ;
                
                if(isset($data_send['request_companyName'])){
                    $data[] = 'companyName:\"'.addslashes($data_send['request_companyName']).'\"' ;
                    unset($data_manage['request_companyName']);
                }
                
                if(isset($data_send['request_contactName'])){
                    $data[] = 'contactName:\"'.addslashes($data_send['request_contactName']).'\"' ;
                    unset($data_manage['request_contactName']);
                }
                
                if(isset($data_send['request_email'])){
                    $data[] = 'email:\"'.addslashes($data_send['request_email']).'\"' ;
                    unset($data_manage['request_email']);
                }
                
                if(isset($data_send['request_jobberWebUri'])){
                    $data[] = 'jobberWebUri:\"'.addslashes($data_send['request_jobberWebUri']).'\"' ;
                    unset($data_manage['request_jobberWebUri']);
                }
                
                if(isset($data_send['request_phone'])){
                    $data[] = 'phone:\"'.addslashes($data_send['request_phone']).'\"' ;
                    unset($data_manage['request_phone']);
                }
                
                if(isset($data_send['request_source'])){
                    $data[] = 'source:\"'.addslashes($data_send['request_source']).'\"' ;
                    unset($data_manage['request_source']);
                }
                
                if(isset($data_send['request_title'])){
                    $data[] = 'title:\"'.addslashes($data_send['request_title']).'\"' ;
                    unset($data_manage['request_title']);
                }

                $body = '{
                 "query": "mutation SampleMutation {    requestCreate(      input: {'.implode(",", $data).'}  ) {    request {      id    }    userErrors {      message      path    }  } }",
                 "operationName": "SampleMutation"
                }';
                $main_response = wp_remote_post($url,
                    array(
                        'headers' => $header,
                        'body' => $body,
                    )
                );

                $json_response = wp_remote_retrieve_body($main_response);
                
                $response = json_decode($json_response,1);

                        
                if ( is_wp_error( $main_response ) ) {
                    $log = "Form ID: ".$form_id."\n";
                    $log .= "Error: ".wp_json_encode( $main_response )."\n";
                    $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
                    
                    $send_to = get_option( 'wcc_cf7_getjobber_notification_send_to ' );
                    if ( $send_to ) {
                        $to = $send_to;
                        $subject = get_option( 'wcc_cf7_getjobber_notification_subject' );
                        $body = "Form ID: ".$form_id."<br>";
                        $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                        $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                        $headers = array(
                            'Content-Type: text/html; charset=UTF-8',
                        );
                        wp_mail( $to, $subject, $body, $headers );
                    }
                    
                    
                    $wcc_cf7_getjobber_debug = get_option("wcc_cf7_getjobber_debug");
                    $wcc_cf7_getjobber_debug .= $log."\n\n";
                    update_option("wcc_cf7_getjobber_debug",$wcc_cf7_getjobber_debug);
                }

            }
        }
        
        return $response;
    }
    
    
    function addFile( $data, $form_id ) {
     
        $header = array(
            'Authorization' => 'Token token='.$this->key,
            'Content-Type' => 'multipart/form-data',
            'content-type' => 'multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW',
        );


        
        if ( strpos( $this->url, 'freshsales.io' ) !== false ) {
            $url = $this->url.'/api/documents';
        } else {
            $url = $this->url.'/crm/sales/api/documents';
        }
       
        $data = wp_json_encode($data);

        $main_response = wp_remote_post($url,
            array(
                'headers' => $header,
                "body"  => $data
            )
        );


        $json_response = wp_remote_retrieve_body($main_response);
        $response = json_decode($json_response,1);

         
        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wcc_cf7_getjobber_notification_send_to	' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wcc_cf7_getjobber_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            $wcc_cf7_getjobber_debug = get_option("wcc_cf7_getjobber_debug");
            $wcc_cf7_getjobber_debug .= $log."\n\n";
            update_option("wcc_cf7_getjobber_debug",$wcc_cf7_getjobber_debug);
        }
        
        
        return $response;
    }
}