<?php if(!defined('ABSPATH')) exit; ?>
<div class="wrap">
    <?php require "header.php" ?>
    <form method="post">
        <div class="wcc-card wcc-mt-15">
            <h2 class="wcc-card-title"><?php echo esc_html(empty($info['id']) ? "Add" : "Edit") ?> Integration</h2>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label title="<?php esc_html_e( 'Name', 'wcc-cf7-to-clio' ); ?>" for='accounts'><?php esc_html_e( 'Name', 'wcc-cf7-to-clio' ); ?></label></th>
                        <td>
                            <input type="text" name="name" class="wcc-input" id="name" required="required" value="<?php echo (isset($info['name']) ? esc_html($info['name']) : "") ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label title="<?php esc_html_e( 'Clio Account', 'wcc-cf7-to-clio' ); ?>" for='accounts'><?php esc_html_e( 'Clio Account', 'wcc-cf7-to-clio' ); ?></label></th>
                        <td>
                            <select name="accounts" class="wcc-input" id="accounts" required="required">
                                <option value=""><?php esc_html_e( 'Select a account', 'wcc-cf7-to-clio' ); ?></option>
                                <?php
                                    foreach ( $accounts as $key => $value ) {
                                        $selected = '';
                                        if ( isset($info['account_id']) && $value['id'] == $info['account_id'] ) {
                                            $selected = ' selected="selected"';
                                        }
                                        ?>
                                            <option value="<?php echo esc_attr($value['id']); ?>"<?php echo esc_attr($selected); ?>><?php echo esc_attr($value['name']); ?></option>
                                        <?php
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label title="<?php esc_html_e( 'Module', 'wcc-cf7-to-clio' ); ?>" for='wcc_cf7_clio_module'><?php esc_html_e( 'Module', 'wcc-cf7-to-clio' ); ?></label></th>
                        <td>
                            <select name="wcc_cf7_clio_module" class="wcc-input" id="wcc_cf7_clio_module" required="required">
                                <option value=""><?php esc_html_e( 'Select a module', 'wcc-cf7-to-clio' ); ?></option>
                                <?php
                                    $modules = WccCf7Clio::$modules;
                                    foreach ( $modules as $key => $value ) {
                                        $selected = '';
                                        if ( isset($info['module']) && $key == $info['module'] ) {
                                            $selected = ' selected="selected"';
                                        }
                                        ?>
                                            <option value="<?php echo esc_attr($key); ?>"<?php echo esc_attr($selected); ?>><?php echo esc_attr($value); ?></option>
                                        <?php
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label title="<?php esc_html_e( 'Form', 'wcc-cf7-to-clio' ); ?>" for='forms'><?php esc_html_e( 'Form', 'wcc-cf7-to-clio' ); ?></label></th>
                        <td>
                            <select name="forms" class="wcc-input" id="forms" required="required">
                                <option value=""><?php esc_html_e( 'Select a form', 'wcc-cf7-to-clio' ); ?></option>
                                <?php
                                    foreach ( $forms as $key => $value ) {
                                        $selected = '';
                                        if ( isset($info['form_id']) && $value['id'] == $info['form_id'] ) {
                                            $selected = ' selected="selected"';
                                        }
                                        ?>
                                            <option value="<?php echo esc_attr($value['id']); ?>"<?php echo esc_attr($selected); ?>><?php echo esc_attr($value['name']); ?></option>
                                        <?php
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label title="<?php esc_html_e( 'Clio CRM Integration?', 'wcc-cf7-to-clio' ); ?>" for="wcc-switch"><?php esc_html_e( 'Clio CRM Integration?', 'wcc-cf7-to-clio' ); ?></label></th>
                        <td>
                            <input type="hidden" name="cf7_clio" value="0" />
                            <div class="switch-wrapper switch-display-options">
                                <div  class="wcc-switch-control">
                                    <input  id="wcc-switch" value="1"  type="checkbox" name="cf7_clio" class="wcc-switch" <?php echo esc_attr( (isset($info['status']) && $info['status']) ? esc_attr(' checked') : '' ); ?>>
                                    <label  for="wcc-switch" class="blue">
                                    </label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label title="<?php esc_html_e( 'Action Event', 'wcc-cf7-to-clio' ); ?>" for="wcc_cf7_clio_action"><?php esc_html_e( 'Action Event', 'wcc-cf7-to-clio' ); ?></label></th>
                        <td>
                            <fieldset>
                                <label title="<?php esc_html_e( 'Create Module Record', 'wcc-cf7-to-clio' ); ?>">
                                    <input type="radio" name="wcc_cf7_clio_action" id="wcc_cf7_clio_action" value="create"<?php echo esc_attr( (!isset($info['action']) || $info['action'] == 'create') ? esc_attr(' checked="checked"') : '' ); ?> /> <?php esc_html_e( 'Create Module Record', 'wcc-cf7-to-clio' ); ?></label>&nbsp;&nbsp;
                                <label title="<?php esc_html_e( 'Create/Update Module Record', 'wcc-cf7-to-clio' ); ?>"><input type="radio" name="wcc_cf7_clio_action" value="create_or_update"<?php echo esc_attr( (isset($info['action']) && $info['action'] == 'create_or_update') ? esc_attr(' checked="checked"') : '' ); ?> /> <?php esc_html_e( 'Create/Update Module Record', 'wcc-cf7-to-clio' ); ?></label>
                            </fieldset>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="maping_fields" >
            <?php if(!empty($info['field'])){ ?>
                <?php foreach ($info['field'] as $key => $value) { ?>
                    <div class="wcc-card wcc-mt-15 connector_setting_block" data-maping_key="<?php echo esc_attr($value['crm_field']) ?>">
                        <table class="widefat wcc_data_table wcc-mt-0 wcc-table form-table">
                            <thead>
                                <tr>
                                    <th class="connector_field_name" >
                                        <?php echo (isset($connector_fields[$value['crm_field']]) ? esc_html($connector_fields[$value['crm_field']]['label']) : "N/A") ?><?php if(!empty($connector_fields[$value['crm_field']]['required'])){ ?> <span class='wcc-text-danger'>(Required)</span><?php } ?>
                                    </th>
                                    <th class="wcc-text-right"><?php if(empty($connector_fields[$value['crm_field']]['required'])){ ?><i title="Remove" class="dashicons dashicons-trash removeMaping"></i><?php } ?></th>
                                </tr>
                                <tr>
                                    <th class="connector_field_name_info" colspan="2">
                                        Name: <?php echo esc_html($value['crm_field']) ?> , Type: <?php echo (isset($connector_fields[$value['crm_field']]) ? esc_html($connector_fields[$value['crm_field']]['type']) : "N/A") ?>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Field Type</td>
                                    <td>
                                        <select name="maping[<?php echo esc_attr($value['crm_field']) ?>][type]" class="wcc-input maping_field_type">
                                            <option <?php echo ($value['fields_type'] == "standard" ? esc_attr("selected") : "") ?> value="standard"><?php esc_html_e( 'Standard Field', 'wcc-cf7-to-clio' ); ?></option>
                                            <option <?php echo ($value['fields_type'] == "custom" ? esc_attr("selected") : "") ?> value="custom"><?php esc_html_e( 'Custom Value', 'wcc-cf7-to-clio' ); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Value</td>
                                    <td>
                                        <div class="wcc_custom_value"  style="display: <?php echo ($value['fields_type'] == "standard" ? esc_attr("none") : esc_attr("block")) ?>;">
                                            <textarea class="wcc-input" name="maping[<?php echo esc_attr($value['crm_field']) ?>][custom_value]"><?php echo ($value['fields_type'] == "custom" ? esc_attr($value['value']) : "") ?></textarea>
                                        </div>
                                        <select name="maping[<?php echo esc_attr($value['crm_field']) ?>][value]" class="wcc-input form_value_selector">
                                            <option value=''>Select Field</option>
                                            <?php if(isset($form_fields)){ ?>
                                                <?php foreach ($form_fields as $kkk => $vvv) { ?>
                                                    <option <?php echo ($value['fields_type'] == "standard" && $kkk == $value['value'] ? esc_attr("selected") : "") ?> value="<?php echo esc_attr($kkk) ?>"><?php echo esc_attr($vvv) ?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
        <div class="wcc-card wcc-p-0 wcc-mt-15 connector_map_fields" <?php if(empty($info['account_id']) || empty($info['account_id']) || empty($info['account_id'])){ ?> style="display:none;" <?php } ?>>
            <table class="form-table widefat wcc_data_table wcc-mt-0 wcc-table">
                <thead>
                    <tr>
                        <th colspan="2">Add New Field</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            <select name="connector_fields" class="wcc-input" id="connector_fields">
                                <option value="">Select Field</option>
                                <?php if(!empty($connector_fields)){ ?>                                    
                                    <?php foreach ($connector_fields as $key => $value) { ?>
                                        <option data-type='<?php echo esc_attr($value['type']) ?>' <?php if(isset($info['field_keys']) && in_array($key, $info['field_keys'])){?>disabled="disabled"<?php } ?> value='<?php echo esc_attr($key) ?>'><?php echo esc_attr($value['label']) ?></option>
                                    <?php } ?>
                                <?php } ?>
                            </select>
                        </td>
                        <td>
                            <button title="Add Field" type="button" class="button button-default" id="wcc_add_maping_val"><i class="dashicons dashicons-plus"></i> Add Field</button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>


        <div class="wcc-card wcc-p-0 wcc-mt-15 connector_map_fields" <?php if(empty($info['account_id'])){ ?> style="display:none;" <?php } ?>>
            <table class="form-table widefat wcc_data_table  wcc-table">
                <thead>
                    <tr>
                        <th><span class="wcc-float-left " style="margin-right: 20px;">Conditional Logic</span> <input type="hidden" name="enable_condition" value="0" />
                            <div class="switch-wrapper switch-display-options">
                                <div  class="wcc-switch-control">
                                    <input  id="wcc-switch-enable_condition" value="1"  type="checkbox" name="enable_condition" class="wcc-switch" <?php echo ( (isset($info['enable_condition']) && $info['enable_condition']) ? ' checked' : '' ); ?>>
                                    <label  for="wcc-switch-enable_condition" class="blue">
                                    </label>
                                </div>
                            </div></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="condition_login_section" <?php if(!empty($info['account_id']) && isset($info['enable_condition']) && $info['enable_condition']){ ?>     display: table-row; <?php }else{ ?>style="display:none;"<?php } ?>>
                        <th>Process this feed if  <select name="condition_login" class="wcc-input" style="max-width: 200px !important;">
                            <option value='and'>All</option>
                            <option value='or'>Any</option>
                        </select> of the following match:</th>
                    </tr>
                </tbody>
            </table>
        </div>


        <div class="wcc-card wcc-p-0 wcc-mt-15 wcc-b-0 condition_login_section_main" style="border: 0;<?php if(!empty($info['account_id']) && isset($info['enable_condition']) && $info['enable_condition']){ ?> display: block; <?php }else{ ?>display:none;<?php } ?>" >
            <table class="form-table widefat wcc_data_table  wcc-table">
                <thead>
                    <tr>
                        <th colspan="4">Conditions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!empty($info['conditions'])){ ?>
                        <?php foreach ($info['conditions'] as $conditions_key => $conditions_value) { ?>
                            <tr>
                                <td>
                                    <select name="conditions[field][]" class="wcc-input conditions-field" >
                                        <?php if(!empty($condition_fields)){ ?>
                                            <?php foreach ($condition_fields as $key => $value) { ?>
                                                <option <?php echo $conditions_value['field']  == $key ? "selected='selected'" : "" ?> data-choice='<?php echo json_encode($value['choices']) ?>' value='<?php echo $key ?>'><?php echo $value['label'] ?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="conditions[condition][]" class="wcc-input" >
                                        <option <?php echo $conditions_value['field']  == "is" ? "selected='selected'" : "" ?> value="is">is</option><option <?php echo $conditions_value['field']  == "isnot" ? "selected='selected'" : "" ?> value="isnot">is not</option><option <?php echo $conditions_value['field']  == ">" ? "selected='selected'" : "" ?> value=">">greater than</option><option <?php echo $conditions_value['field']  == "<" ? "selected='selected'" : "" ?> value="<">less than</option><option <?php echo $conditions_value['field']  == "contains" ? "selected='selected'" : "" ?> value="contains">contains</option><option <?php echo $conditions_value['field']  == "starts_with" ? "selected='selected'" : "" ?> value="starts_with">starts with</option><option <?php echo $conditions_value['field']  == "ends_with" ? "selected='selected'" : "" ?> value="ends_with">ends with</option>
                                    </select>
                                </td>
                                <td class="conditions-input">
                                    <?php 
                                    if(!empty($condition_fields[$conditions_value['field']]['choices'])){ ?>
                                        
                                        <select name="conditions[value][]" class="wcc-input" >
                                            <?php foreach ($condition_fields[$conditions_value['field']]['choices'] as $choiceskey => $choicesvalue) { ?>
                                                <option <?php echo $conditions_value['value'] == $choicesvalue ? "checked='checked'" : "" ?> value='<?php echo $choicesvalue ?>'><?php echo $choicesvalue ?></option>
                                            <?php } ?>
                                        </select>
                                    
                                    <?php } else{ ?>
                                        <input type="text" name="conditions[value][]" class="wcc-input" required="required" value="<?php echo $conditions_value['value'] ?>" placeholder="Enter a Value">
                                    <?php } ?>
                                </td>
                                <th class="wcc-text-right" style="border:0 !important"><i title="Remove" class="dashicons dashicons-trash removeCondition"></i></th>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="4" class="wcc-text-right">
                            <button title="Add Condition" type="button" class="button button-default" id="wcc_add_condition"><i class="dashicons dashicons-plus"></i> Add Condition</button>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <p>
            <input title="Save Changes" type='submit' class='button-primary button' name="wcc_cf7_clio_integration_submit" value="<?php esc_html_e( 'Save Changes', 'wcc-cf7-to-clio' ); ?>" />
            <input type="hidden" name="_wpnonce" value="<?php echo esc_attr(wp_create_nonce( 'wcc_cf7_clio_integration' )) ?>">
        </p>
        <input type="hidden" name="edit_id" value="<?php echo (isset($info['id']) ? esc_attr($info['id']) : "") ?>">
    </form>
    <div class="field_info">
        <?php 
        $fields = isset($connector_fields) ? $connector_fields : array();
        require_once plugin_dir_path( __FILE__ ) . 'integration_field_info.php';
        ?>
    </div>
    <?php require "message.php" ?>
</div>
<div class="hidden_connector_setting" style="display:none;">
    <div class="wcc-card wcc-mt-15 connector_setting_block">
        <table class="widefat wcc_data_table wcc-mt-0 wcc-table form-table">
            <thead>
                <tr>
                    <th class="connector_field_name" ></th>
                    <th class="wcc-text-right"><i title="Remove" class="dashicons dashicons-trash removeMaping"></i></th>
                </tr>
                <tr>
                    <th class="connector_field_name_info" colspan="2"></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Field Type</td>
                    <td>
                        <select name="maping[{{connector_field}}][type]" class="wcc-input maping_field_type">
                            <option value="standard"><?php esc_html_e( 'Standard Field', 'wcc-cf7-to-clio' ); ?></option>
                            <option value="custom"><?php esc_html_e( 'Custom Value', 'wcc-cf7-to-clio' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Value</td>
                    <td>
                        <div class="wcc_custom_value" style="display: none;">
                            <textarea class="wcc-input" name="maping[{{connector_field}}][custom_value]"></textarea>
                        </div>
                        <select name="maping[{{connector_field}}][value]" class="wcc-input form_value_selector">
                            <option value=''>Select Field</option>
                            <?php if(isset($form_fields)){ ?>
                                <?php foreach ($form_fields as $key => $value) { ?>
                                    <option value="<?php echo esc_attr($key) ?>"><?php echo esc_attr($value) ?></option>
                                <?php } ?>
                            <?php } ?>
                        </select>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>


<div class="hidden_condition_setting_hidden" style="display:none;">
<table class="hidden_condition_setting" >
    <tbody>
        <tr>
            <td>
                <select name="conditions[field][]" class="wcc-input conditions-field" >
                    <?php if(!empty($condition_fields)){ ?>
                        <?php foreach ($condition_fields as $key => $value) { ?>
                            <option data-choice='<?php echo json_encode($value['choices']) ?>' value='<?php echo $key ?>'><?php echo $value['label'] ?></option>
                        <?php } ?>
                    <?php } ?>
                </select>
            </td>
            <td>
                <select name="conditions[condition][]" class="wcc-input" >
                    <option value="is">is</option><option value="isnot">is not</option><option value=">">greater than</option><option value="<">less than</option><option value="contains">contains</option><option value="starts_with">starts with</option><option value="ends_with">ends with</option>
                </select>
            </td>
            <td class="conditions-input">
                <?php $condition_fields_first = array_shift(array_values($condition_fields)); if(!empty($condition_fields_first['choices'])) { ?>
                    <select name="conditions[value][]" class="wcc-input" >
                        <?php foreach ($condition_fields_first['choices'] as $choiceskey => $choicesvalue) { ?>
                            <option  value='<?php echo $choicesvalue ?>'><?php echo $choicesvalue ?></option>
                        <?php } ?>
                    </select>
                <?php }else{ ?>
                    <input type="text" name="conditions[value][]" class="wcc-input" required="required" value="" placeholder="Enter a Value">
                <?php } ?>
            </td>
            <th class="wcc-text-right" style="border:0 !important"><i title="Remove" class="dashicons dashicons-trash removeCondition"></i></th>
        </tr>
    </tbody>
</table>
</div>